/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;

public class ByMinuteRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private final List<Integer> minuteList;

    public ByMinuteRule(List<Integer> minuteList, Frequency frequency) {
        super(frequency);
        this.minuteList = minuteList;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.minuteList.isEmpty()) {
            return dates;
        }
        ArrayList minutelyDates = new ArrayList();
        for (Temporal date : dates) {
            if (EnumSet.of(Frequency.HOURLY, Frequency.DAILY, Frequency.WEEKLY, Frequency.MONTHLY, Frequency.YEARLY).contains((Object)this.getFrequency())) {
                minutelyDates.addAll(new ExpansionFilter().apply(date));
                continue;
            }
            Optional<Temporal> limit = new LimitFilter().apply(date);
            limit.ifPresent(minutelyDates::add);
        }
        return minutelyDates;
    }

    private class ExpansionFilter
    implements Function<T, List<T>> {
        private ExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            ByMinuteRule.this.minuteList.forEach(minute -> {
                Temporal candidate = ByMinuteRule.this.withTemporalField(date, ChronoField.MINUTE_OF_HOUR, (int)minute);
                retVal.add(candidate);
            });
            return retVal;
        }
    }

    private class LimitFilter
    implements Function<T, Optional<T>> {
        private LimitFilter() {
        }

        @Override
        public Optional<T> apply(T date) {
            if (ByMinuteRule.this.minuteList.contains(ByMinuteRule.this.getMinute(date))) {
                return Optional.of(date);
            }
            return Optional.empty();
        }
    }
}

