/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Month;
import java.time.YearMonth;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByMonthDayRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private transient Logger log = LoggerFactory.getLogger(ByMonthDayRule.class);
    private final List<Integer> monthDayList;
    private final Recur.Skip skip;

    public ByMonthDayRule(List<Integer> monthDayList, Frequency frequency) {
        this(monthDayList, frequency, Recur.Skip.OMIT);
    }

    public ByMonthDayRule(List<Integer> monthDayList, Frequency frequency, Recur.Skip skip) {
        super(frequency);
        this.monthDayList = monthDayList;
        this.skip = skip;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.monthDayList.isEmpty()) {
            return dates;
        }
        ArrayList monthDayDates = new ArrayList();
        for (Temporal date : dates) {
            if (EnumSet.of(Frequency.MONTHLY, Frequency.YEARLY).contains((Object)this.getFrequency())) {
                monthDayDates.addAll(new ExpansionFilter().apply(date));
                continue;
            }
            Optional<Temporal> limit = new LimitFilter().apply(date);
            limit.ifPresent(monthDayDates::add);
        }
        return monthDayDates;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LoggerFactory.getLogger(ByMonthDayRule.class);
    }

    private class ExpansionFilter
    implements Function<T, List<T>> {
        private ExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            YearMonth yearMonth = YearMonth.of(ByMonthDayRule.this.getYear(date), ByMonthDayRule.this.getMonth(date).getMonthOfYear());
            for (int monthDay : ByMonthDayRule.this.monthDayList) {
                Object candidate;
                if (Month.of(ByMonthDayRule.this.getMonth(date).getMonthOfYear()).maxLength() < Math.abs(monthDay)) {
                    if (!ByMonthDayRule.this.log.isTraceEnabled()) continue;
                    ByMonthDayRule.this.log.trace("Invalid day of month: {}", (Object)monthDay);
                    continue;
                }
                if (monthDay > 0) {
                    if (yearMonth.lengthOfMonth() < monthDay) {
                        if (ByMonthDayRule.this.skip == Recur.Skip.BACKWARD) {
                            candidate = ByMonthDayRule.this.withTemporalField(date, ChronoField.DAY_OF_MONTH, yearMonth.lengthOfMonth());
                        } else {
                            if (ByMonthDayRule.this.skip != Recur.Skip.FORWARD) continue;
                            candidate = ByMonthDayRule.this.withTemporalField(date.plus(1L, ChronoUnit.MONTHS), ChronoField.DAY_OF_MONTH, 1);
                        }
                    } else {
                        candidate = ByMonthDayRule.this.withTemporalField(date, ChronoField.DAY_OF_MONTH, monthDay);
                    }
                } else if (-yearMonth.lengthOfMonth() > monthDay) {
                    if (ByMonthDayRule.this.skip == Recur.Skip.BACKWARD) {
                        Temporal adjustedDate = date.minus(1L, ChronoUnit.MONTHS);
                        candidate = ByMonthDayRule.this.withTemporalField(adjustedDate, ChronoField.DAY_OF_MONTH, YearMonth.from(adjustedDate).lengthOfMonth());
                    } else {
                        if (ByMonthDayRule.this.skip != Recur.Skip.FORWARD) continue;
                        candidate = ByMonthDayRule.this.withTemporalField(date, ChronoField.DAY_OF_MONTH, -yearMonth.lengthOfMonth());
                    }
                } else {
                    candidate = ByMonthDayRule.this.withTemporalField(date, ChronoField.DAY_OF_MONTH, yearMonth.lengthOfMonth() + 1 + monthDay);
                }
                retVal.add(candidate);
            }
            return retVal;
        }
    }

    private class LimitFilter
    implements Function<T, Optional<T>> {
        private LimitFilter() {
        }

        @Override
        public Optional<T> apply(T date) {
            if (ByMonthDayRule.this.monthDayList.contains(ByMonthDayRule.this.getDayOfMonth(date))) {
                return Optional.of(date);
            }
            return Optional.empty();
        }
    }
}

