/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fortuna.ical4j.model.Month;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;

public class ByMonthRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private final List<Month> monthList;
    private final Recur.Skip skip;

    public ByMonthRule(List<Month> monthList, Frequency frequency) {
        this(monthList, frequency, Recur.Skip.OMIT);
    }

    public ByMonthRule(List<Month> monthList, Frequency frequency, Recur.Skip skip) {
        super(frequency);
        this.monthList = monthList;
        this.skip = skip;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.monthList.isEmpty()) {
            return dates;
        }
        ArrayList monthlyDates = new ArrayList();
        for (Temporal date : dates) {
            if (this.getFrequency() == Frequency.YEARLY) {
                monthlyDates.addAll(new ExpansionFilter().apply(date));
                continue;
            }
            Optional<Temporal> limit = new LimitFilter().apply(date);
            limit.ifPresent(monthlyDates::add);
        }
        return monthlyDates;
    }

    private class ExpansionFilter
    implements Function<T, List<T>> {
        private ExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            for (Month month : ByMonthRule.this.monthList) {
                Object candidate;
                if (month.isLeapMonth()) {
                    if (ByMonthRule.this.skip == Recur.Skip.BACKWARD) {
                        candidate = ByMonthRule.this.withTemporalField(date, ChronoField.MONTH_OF_YEAR, month.getMonthOfYear());
                    } else {
                        if (ByMonthRule.this.skip != Recur.Skip.FORWARD) continue;
                        candidate = ByMonthRule.this.withTemporalField(date, ChronoField.MONTH_OF_YEAR, month.getMonthOfYear() + 1);
                    }
                } else {
                    candidate = ByMonthRule.this.withTemporalField(date, ChronoField.MONTH_OF_YEAR, month.getMonthOfYear());
                }
                retVal.add(candidate);
            }
            return retVal;
        }
    }

    private class LimitFilter
    implements Function<T, Optional<T>> {
        private LimitFilter() {
        }

        @Override
        public Optional<T> apply(T date) {
            if (ByMonthRule.this.monthList.contains(ByMonthRule.this.getMonth(date))) {
                return Optional.of(date);
            }
            return Optional.empty();
        }
    }
}

