/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;

public class BySecondRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private final List<Integer> secondList;

    public BySecondRule(List<Integer> secondList, Frequency frequency) {
        super(frequency);
        this.secondList = secondList;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.secondList.isEmpty()) {
            return dates;
        }
        ArrayList secondlyDates = new ArrayList();
        for (Temporal date : dates) {
            if (this.getFrequency() == Frequency.SECONDLY) {
                Optional<Temporal> limit = new LimitFilter().apply(date);
                limit.ifPresent(secondlyDates::add);
                continue;
            }
            secondlyDates.addAll(new ExpansionFilter().apply(date));
        }
        return secondlyDates;
    }

    private class LimitFilter
    implements Function<T, Optional<T>> {
        private LimitFilter() {
        }

        @Override
        public Optional<T> apply(T date) {
            if (BySecondRule.this.secondList.contains(BySecondRule.this.getSecond(date))) {
                return Optional.of(date);
            }
            return Optional.empty();
        }
    }

    private class ExpansionFilter
    implements Function<T, List<T>> {
        private ExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            BySecondRule.this.secondList.forEach(second -> {
                Temporal candidate = BySecondRule.this.withTemporalField(date, ChronoField.SECOND_OF_MINUTE, (int)second);
                retVal.add(candidate);
            });
            return retVal;
        }
    }
}

