/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.transform.Transformer;

public class BySetPosRule<T extends Temporal>
implements Transformer<List<T>> {
    private static final Comparator<Temporal> ONSET_COMPARATOR = TemporalComparator.INSTANCE;
    private final List<Integer> setPosList;

    public BySetPosRule(List<Integer> setPosList) {
        this.setPosList = setPosList;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.setPosList.isEmpty() || dates.isEmpty()) {
            return dates;
        }
        dates.sort(ONSET_COMPARATOR);
        ArrayList<Temporal> setPosDates = new ArrayList<Temporal>();
        int size = dates.size();
        for (int setPos : this.setPosList) {
            if (setPos > 0 && setPos <= size) {
                setPosDates.add((Temporal)dates.get(setPos - 1));
                continue;
            }
            if (setPos >= 0 || setPos < -size) continue;
            setPosDates.add((Temporal)dates.get(size + setPos));
        }
        return setPosDates;
    }
}

