/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.DayOfWeek;
import java.time.temporal.Temporal;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByWeekNoRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private transient Logger log = LoggerFactory.getLogger(ByWeekNoRule.class);
    private final List<Integer> weekNoList;
    private final WeekFields weekFields;

    public ByWeekNoRule(List<Integer> weekNoList, Frequency frequency) {
        this(weekNoList, frequency, null);
    }

    public ByWeekNoRule(List<Integer> weekNoList, Frequency frequency, DayOfWeek firstDayOfWeek) {
        super(frequency);
        this.weekNoList = weekNoList;
        this.weekFields = firstDayOfWeek != null ? WeekFields.of(firstDayOfWeek, 4) : WeekFields.of(DayOfWeek.MONDAY, 4);
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.weekNoList.isEmpty()) {
            return dates;
        }
        ArrayList<Temporal> weekNoDates = new ArrayList<Temporal>();
        for (Temporal date : dates) {
            int numWeeksInYear = (int)this.weekFields.weekOfWeekBasedYear().rangeRefinedBy(date).getMaximum();
            for (int weekNo : this.weekNoList) {
                Temporal candidate;
                if (weekNo == 0 || weekNo < -numWeeksInYear || weekNo > numWeeksInYear) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Invalid week of year: " + weekNo);
                    continue;
                }
                if (weekNo > 0) {
                    candidate = this.withTemporalField(date, this.weekFields.weekOfWeekBasedYear(), weekNo);
                } else {
                    if (numWeeksInYear < -weekNo) continue;
                    candidate = this.withTemporalField(date, this.weekFields.weekOfWeekBasedYear(), numWeeksInYear + 1 + weekNo);
                }
                weekNoDates.add(candidate);
            }
        }
        return weekNoDates;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LoggerFactory.getLogger(ByWeekNoRule.class);
    }
}

