/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByYearDayRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private transient Logger log = LoggerFactory.getLogger(ByYearDayRule.class);
    private final List<Integer> yearDayList;

    public ByYearDayRule(List<Integer> yearDayList, Frequency frequency) {
        super(frequency);
        this.yearDayList = yearDayList;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.yearDayList.isEmpty()) {
            return dates;
        }
        ArrayList yearDayDates = new ArrayList();
        for (Temporal date : dates) {
            if (this.getFrequency() == Frequency.YEARLY) {
                yearDayDates.addAll(new ExpansionFilter().apply(date));
                continue;
            }
            Optional<Temporal> limit = new LimitFilter().apply(date);
            limit.ifPresent(yearDayDates::add);
        }
        return yearDayDates;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LoggerFactory.getLogger(ByYearDayRule.class);
    }

    private class ExpansionFilter
    implements Function<T, List<T>> {
        private ExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            int numDaysInYear = Year.of(ByYearDayRule.this.getYear(date)).length();
            for (int yearDay : ByYearDayRule.this.yearDayList) {
                Object candidate;
                if (yearDay == 0 || yearDay < -numDaysInYear || yearDay > numDaysInYear) {
                    if (!ByYearDayRule.this.log.isTraceEnabled()) continue;
                    ByYearDayRule.this.log.trace("Invalid day of year: " + yearDay);
                    continue;
                }
                if (yearDay > 0) {
                    candidate = ByYearDayRule.this.withTemporalField(date, ChronoField.DAY_OF_YEAR, yearDay);
                } else {
                    if (numDaysInYear < -yearDay) continue;
                    candidate = ByYearDayRule.this.withTemporalField(date, ChronoField.DAY_OF_YEAR, numDaysInYear + 1 + yearDay);
                }
                retVal.add(candidate);
            }
            return retVal;
        }
    }

    private class LimitFilter
    implements Function<T, Optional<T>> {
        private LimitFilter() {
        }

        @Override
        public Optional<T> apply(T date) {
            if (ByYearDayRule.this.yearDayList.contains(ByYearDayRule.this.getDayOfYear(date))) {
                return Optional.of(date);
            }
            return Optional.empty();
        }
    }
}

