/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.net.URI;
import java.util.regex.Pattern;
import net.fortuna.ical4j.model.PropertyCodec;
import net.fortuna.ical4j.util.Uris;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public final class Strings {
    public static final Pattern PARAM_QUOTE_PATTERN = Pattern.compile("[:;,]|[^\\p{ASCII}]");
    public static final String LINE_SEPARATOR = "\r\n";

    private Strings() {
    }

    public static String quote(Object aValue) {
        if (aValue != null) {
            return "\"" + aValue + "\"";
        }
        return "\"\"";
    }

    public static String quote(URI uri) {
        return Strings.quote(Uris.decode(Strings.valueOf(uri)));
    }

    public static String unquote(String aValue) {
        if (aValue != null && aValue.startsWith("\"") && aValue.endsWith("\"")) {
            return aValue.substring(0, aValue.length() - 1).substring(1);
        }
        return aValue;
    }

    public static String escape(String aValue) {
        try {
            return PropertyCodec.INSTANCE.encode(aValue);
        }
        catch (EncoderException e) {
            return aValue;
        }
    }

    public static String unescape(String aValue) {
        try {
            return PropertyCodec.INSTANCE.decode(aValue);
        }
        catch (DecoderException e) {
            return aValue;
        }
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

