/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationRule;

public abstract class AbstractValidationRuleSet<T>
implements Serializable {
    protected final Set<ValidationRule<? super T>> rules;

    @SafeVarargs
    public AbstractValidationRuleSet(ValidationRule<? super T> ... rules) {
        this.rules = Collections.unmodifiableSet(new HashSet<ValidationRule<? super T>>(Arrays.asList(rules)));
    }

    public Set<ValidationRule<? super T>> getRules() {
        return this.rules;
    }

    public abstract List<ValidationEntry> apply(String var1, T var2);

    protected List<String> matches(List<String> instances, Predicate<String> matchPredicate) {
        return instances.stream().filter(matchPredicate).collect(Collectors.toList());
    }
}

