/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.validate.AbstractValidationRuleSet;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.Validator;

public abstract class AbstractValidator<T>
implements Validator<T> {
    private final List<AbstractValidationRuleSet<? super T>> ruleSets;
    private final String context;

    @SafeVarargs
    public AbstractValidator(String context, AbstractValidationRuleSet<? super T> ... ruleSets) {
        this.ruleSets = Arrays.asList(ruleSets);
        this.context = context;
    }

    @Override
    public ValidationResult validate(T target) throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        for (AbstractValidationRuleSet<T> ruleSet : this.ruleSets) {
            result.getEntries().addAll(ruleSet.apply(this.context, target));
        }
        return result;
    }
}

