/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Color;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Image;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Name;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RefreshInterval;
import net.fortuna.ical4j.model.property.Source;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.model.property.immutable.ImmutableVersion;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ITIPValidator;
import net.fortuna.ical4j.validate.PropertyContainerRuleSet;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public class CalendarValidatorImpl
implements Validator<Calendar> {
    protected final List<Class<? extends Property>> calendarProperties = new ArrayList<Class<? extends Property>>();
    private final PropertyContainerRuleSet<Calendar> rules;

    @SafeVarargs
    public CalendarValidatorImpl(ValidationRule<Calendar> ... rules) {
        this.rules = new PropertyContainerRuleSet<Calendar>(rules);
        Collections.addAll(this.calendarProperties, CalScale.class, Method.class, ProdId.class, Version.class, Uid.class, LastModified.class, Url.class, RefreshInterval.class, Source.class, Color.class, Name.class, Description.class, Categories.class, Image.class);
    }

    @Override
    public ValidationResult validate(Calendar target) throws ValidationException {
        Object version;
        ValidationResult result = new ValidationResult(this.rules.apply("VCALENDAR", target));
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed") && ((Optional)(version = target.getVersion())).isPresent() && !ImmutableVersion.VERSION_2_0.equals(((Optional)version).get())) {
            result.getEntries().add(new ValidationEntry("Unsupported Version: " + ((Version)((Optional)version).get()).getValue(), ValidationEntry.Severity.ERROR, "VCALENDAR"));
        }
        if (target.getComponents().isEmpty()) {
            result.getEntries().add(new ValidationEntry("Calendar must contain at least one component", ValidationEntry.Severity.ERROR, "VCALENDAR"));
        }
        for (Property property : target.getProperties()) {
            boolean isCalendarProperty;
            boolean bl = isCalendarProperty = this.calendarProperties.stream().filter(calProp -> calProp.isInstance(property)) != null;
            if (property instanceof XProperty || isCalendarProperty) continue;
            result.getEntries().add(new ValidationEntry("Invalid property: " + property.getName(), ValidationEntry.Severity.ERROR, "VCALENDAR"));
        }
        Optional<Method> method = target.getMethod();
        if (method.isPresent()) {
            result = result.merge(new ITIPValidator().validate(target));
            for (CalendarComponent component : target.getComponents()) {
                component.validate(method.get());
            }
        }
        return result;
    }
}

