/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.validate.AbstractValidationRuleSet;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationRule;

public class ComponentContainerRuleSet
extends AbstractValidationRuleSet<ComponentContainer<? extends Component>> {
    @SafeVarargs
    public ComponentContainerRuleSet(ValidationRule<ComponentContainer<? extends Component>> ... rules) {
        super(rules);
    }

    @Override
    public List<ValidationEntry> apply(String context, ComponentContainer<? extends Component> target) {
        ArrayList<ValidationEntry> results = new ArrayList<ValidationEntry>();
        for (ValidationRule rule : this.rules) {
            List<Object> matches = Collections.emptyList();
            if (!rule.getPredicate().test(target)) continue;
            int total = rule.getInstances().stream().mapToInt(s -> target.getComponents((String)s).size()).sum();
            switch (rule.getType()) {
                case None: {
                    matches = this.matches(rule.getInstances(), s -> !target.getComponents((String)s).isEmpty());
                    break;
                }
                case One: {
                    matches = this.matches(rule.getInstances(), s -> target.getComponents((String)s).size() != 1);
                    break;
                }
                case OneOrLess: {
                    matches = this.matches(rule.getInstances(), s -> target.getComponents((String)s).size() > 1);
                    break;
                }
                case OneOrMore: {
                    matches = this.matches(rule.getInstances(), s -> target.getComponents((String)s).isEmpty());
                    break;
                }
                case OneExclusive: {
                    if (!rule.getInstances().stream().anyMatch(s -> !target.getComponents((String)s).isEmpty() && target.getComponents((String)s).size() != total)) break;
                    matches = rule.getInstances();
                    break;
                }
                case AllOrNone: {
                    if (total <= 0 || total == rule.getInstances().size()) break;
                    results.add(new ValidationEntry(rule, context, new String[0]));
                }
            }
            if (matches.isEmpty()) continue;
            results.add(new ValidationEntry(rule, context, (String[])matches.toArray(String[]::new)));
        }
        return results;
    }
}

