/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VLocation;
import net.fortuna.ical4j.model.component.VResource;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.VVenue;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.validate.AbstractValidator;
import net.fortuna.ical4j.validate.ContentValidator;
import net.fortuna.ical4j.validate.PropertyContainerRuleSet;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public class ComponentValidator<T extends Component>
extends AbstractValidator<T>
implements ContentValidator<Property> {
    public static final ComponentValidator<Available> AVAILABLE = new ComponentValidator("AVAILABLE", new ValidationRule(ValidationRule.ValidationType.One, "DTSTART", "DTSTAMP", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CREATED", "LAST-MODIFIED", "RECURRENCE-ID", "RRULE", "SUMMARY"), new ValidationRule(ValidationRule.ValidationType.OneExclusive, "DTEND", "DURATION"), new ValidationRule((Predicate<Available> & Serializable)a -> a.getProperties("DTSTART", "DTEND").stream().anyMatch(p -> p.getParameters(new String[0]).contains(Value.DATE)), "VAVAILABILITY components and AVAILABLE sub-components MUST be DATE-TIME values", "DTSTART", "DTEND"));
    public static final ComponentValidator<Participant> PARTICIPANT = new ComponentValidator("PARTICIPANT", new ValidationRule(ValidationRule.ValidationType.One, "PARTICIPANT-TYPE", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CALENDAR-ADDRESS", "CREATED", "DESCRIPTION", "DTSTAMP", "GEO", "LAST-MODIFIED", "PRIORITY", "SEQUENCE", "STATUS", "SUMMARY", "URL"));
    public static final ComponentValidator<VAvailability> VAVAILABILITY = new ComponentValidator("VAVAILABILITY", new ValidationRule(ValidationRule.ValidationType.One, true, "UID", "DTSTAMP"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "DTSTAMP", "LAST-MODIFIED", "ORGANIZER", "RECURRENCE-ID", "SEQUENCE", "STATUS", "SUMMARY", "UID", "URL"), new ValidationRule((Predicate<VAvailability> & Serializable)a -> a.getProperties("DTSTART", "DTEND").stream().anyMatch(p -> p.getParameters(new String[0]).contains(Value.DATE)), "VAVAILABILITY components and AVAILABLE sub-components MUST be DATE-TIME values", "DTSTART", "DTEND"));
    public static final ComponentValidator<VEvent> VEVENT = new ComponentValidator("VEVENT", new ValidationRule(ValidationRule.ValidationType.One, true, "UID", "DTSTAMP"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CLASS", "CREATED", "DESCRIPTION", "DTSTART", "GEO", "LAST-MODIFIED", "LOCATION", "ORGANIZER", "PRIORITY", "DTSTAMP", "SEQUENCE", "STATUS", "SUMMARY", "TRANSP", "UID", "URL", "RECURRENCE-ID"), new ValidationRule(ValidationRule.ValidationType.OneExclusive, "DTEND", "DURATION"));
    public static final ComponentValidator<VFreeBusy> VFREEBUSY = new ComponentValidator("VFREEBUSY", new ValidationRule(ValidationRule.ValidationType.One, true, "UID", "DTSTAMP"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CONTACT", "DTSTART", "DTEND", "DURATION", "DTSTAMP", "ORGANIZER", "UID", "URL"), new ValidationRule(ValidationRule.ValidationType.None, "RRULE", "EXRULE", "RDATE", "EXDATE"), new ValidationRule((Predicate<VFreeBusy> & Serializable)a -> a.getProperties("DTSTART", "DTEND").stream().anyMatch(p -> !((DateProperty)p).isUtc()), "VFREEBUSY date properties MUST be in UTC time", "DTSTART", "DTEND"));
    public static final ComponentValidator<VJournal> VJOURNAL = new ComponentValidator("VJOURNAL", new ValidationRule(ValidationRule.ValidationType.One, "DTSTART", "DTSTAMP", "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "BUSYTYPE", "CREATED", "LAST-MODIFIED", "ORGANIZER", "SEQUENCE", "SUMMARY", "URL"), new ValidationRule(ValidationRule.ValidationType.OneExclusive, "DTEND", "DURATION"), new ValidationRule((Predicate<VJournal> & Serializable)a -> a.getProperties("STATUS").stream().anyMatch(p -> !ImmutableStatus.VJOURNAL_DRAFT.equals(p) && !ImmutableStatus.VJOURNAL_FINAL.equals(p) && !ImmutableStatus.VJOURNAL_CANCELLED.equals(p)), "STATUS value not applicable for VJOURNAL", "STATUS"));
    public static final ComponentValidator<VLocation> VLOCATION = new ComponentValidator("VLOCATION", new ValidationRule(ValidationRule.ValidationType.One, true, "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "DESCRIPTION", "GEO", "LOCATION-TYPE", "NAME"));
    public static final ComponentValidator<VResource> VRESOURCE = new ComponentValidator("VRESOURCE", new ValidationRule(ValidationRule.ValidationType.One, true, "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "DESCRIPTION", "GEO", "RESOURCE-TYPE", "NAME"));
    public static final ComponentValidator<VTimeZone> VTIMEZONE = new ComponentValidator("VTIMEZONE", new ValidationRule(ValidationRule.ValidationType.One, "TZID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "LAST-MODIFIED", "TZURL"));
    public static final ComponentValidator<VToDo> VTODO = new ComponentValidator("VTODO", new ValidationRule(ValidationRule.ValidationType.One, true, "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CLASS", "COMPLETED", "CREATED", "DESCRIPTION", "DTSTAMP", "DTSTART", "GEO", "LAST-MODIFIED", "LOCATION", "ORGANIZER", "PERCENT-COMPLETE", "PRIORITY", "RECURRENCE-ID", "SEQUENCE", "STATUS", "SUMMARY", "UID", "URL"), new ValidationRule(ValidationRule.ValidationType.OneExclusive, "DUE", "DURATION"));
    public static final ComponentValidator<VVenue> VVENUE = new ComponentValidator("VVENUE", new ValidationRule(ValidationRule.ValidationType.One, "UID"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "NAME", "DESCRIPTION", "STREET-ADDRESS", "EXTENDED-ADDRESS", "LOCALITY", "REGION", "COUNTRY", "POSTAL-CODE", "TZID", "GEO", "LOCATION-TYPE", "CATEGORIES", "DTSTAMP", "CREATED", "LAST-MODIFIED"));
    public static final ComponentValidator<Observance> OBSERVANCE_ITIP = new ComponentValidator("VTIMEZONE", new ValidationRule(ValidationRule.ValidationType.One, "DTSTART", "TZOFFSETFROM", "TZOFFSETTO"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "TZNAME"));
    public static final ComponentValidator<VAlarm> VALARM_AUDIO = new ComponentValidator("VALARM", new ValidationRule(ValidationRule.ValidationType.One, "ACTION", "TRIGGER"), new ValidationRule(ValidationRule.ValidationType.AllOrNone, "DURATION", "REPEAT"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ATTACH"));
    public static final ComponentValidator<VAlarm> VALARM_DISPLAY = new ComponentValidator("VALARM", new ValidationRule(ValidationRule.ValidationType.One, "ACTION", "DESCRIPTION", "TRIGGER"), new ValidationRule(ValidationRule.ValidationType.AllOrNone, "DURATION", "REPEAT"));
    public static final ComponentValidator<VAlarm> VALARM_EMAIL = new ComponentValidator("VALARM", new ValidationRule(ValidationRule.ValidationType.One, "ACTION", "DESCRIPTION", "TRIGGER", "SUMMARY"), new ValidationRule(ValidationRule.ValidationType.OneOrMore, "ATTENDEE"), new ValidationRule(ValidationRule.ValidationType.AllOrNone, "DURATION", "REPEAT"));
    public static final ComponentValidator<VAlarm> VALARM_ITIP = new ComponentValidator("VALARM", new ValidationRule(ValidationRule.ValidationType.One, "ACTION", "TRIGGER"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "DESCRIPTION", "DURATION", "REPEAT", "SUMMARY"));
    public static final ValidationRule<ComponentContainer<?>> NO_ALARMS = new ValidationRule(ValidationRule.ValidationType.None, "VALARM");

    @SafeVarargs
    public ComponentValidator(String context, ValidationRule<T> ... rules) {
        super(context, new PropertyContainerRuleSet<T>(rules));
    }

    private ComponentValidator(String context, Set<ValidationRule<T>> rules) {
        super(context, new PropertyContainerRuleSet((ValidationRule<T>[])((ValidationRule[])rules.toArray(ValidationRule[]::new))));
    }

    @Override
    public ValidationResult validate(T target) throws ValidationException {
        ValidationResult result = super.validate(target);
        result.getEntries().addAll(((Component)target).getProperties().stream().map(p -> p.validate().getEntries()).flatMap(Collection::stream).collect(Collectors.toSet()));
        return result;
    }

    @Deprecated
    public static void assertNone(String componentName, ComponentList<?> components) throws ValidationException {
        Validator.assertFalse(input -> input.getComponent(componentName) != null, "Content [{0}] is not applicable", false, components, componentName);
    }

    @Deprecated
    public static void assertOneOrLess(String componentName, ComponentList<?> components) throws ValidationException {
        Validator.assertFalse(input -> input.getComponents(componentName).size() > 1, "Content [{0}] must only be specified once", false, components, componentName);
    }
}

