/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.List;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.Validator;

public interface ContentValidator<T extends Content> {
    public static final String ASSERT_NONE_MESSAGE = "Content [{0}] is not applicable";
    public static final String ASSERT_ONE_OR_LESS_MESSAGE = "Content [{0}] must only be specified once";
    public static final String ASSERT_ONE_MESSAGE = "Content [{0}] must be specified once";
    public static final String ASSERT_ONE_OR_MORE_MESSAGE = "Content [{0}] must be specified at least once";

    public static <T extends Content> void assertNone(String name, List<T> content, boolean warn) throws ValidationException {
        Validator.assertFalse(input -> input.parallelStream().anyMatch(c -> c.getName().equals(name)), ASSERT_NONE_MESSAGE, warn, content, name);
    }

    public static <T extends Content> void assertOne(String name, List<T> content, boolean warn) throws ValidationException {
        Validator.assertFalse(input -> input.stream().filter(c -> c.getName().equals(name)).count() != 1L, ASSERT_ONE_MESSAGE, warn, content, name);
    }

    public static <T extends Content> void assertOneOrLess(String name, List<T> content, boolean warn) throws ValidationException {
        Validator.assertFalse(input -> input.stream().filter(c -> c.getName().equals(name)).count() > 1L, ASSERT_ONE_OR_LESS_MESSAGE, warn, content, name);
    }

    public static <T extends Content> void assertOneOrMore(String name, List<T> content, boolean warn) throws ValidationException {
        Validator.assertFalse(input -> input.stream().filter(c -> c.getName().equals(name)).count() < 1L, ASSERT_ONE_OR_MORE_MESSAGE, warn, content, name);
    }
}

