/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.validate.ComponentContainerRuleSet;
import net.fortuna.ical4j.validate.PropertyContainerRuleSet;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public class ITIPValidator
implements Validator<Calendar> {
    private static final PropertyContainerRuleSet<Calendar> PROPS_RULE_SET = new PropertyContainerRuleSet((ValidationRule<T>[])new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.One, "PRODID", "VERSION", "METHOD"), new ValidationRule(ValidationRule.ValidationType.OneOrLess, "CALSCALE")});
    private static final ComponentContainerRuleSet COMPONENTS_RULE_SET = new ComponentContainerRuleSet(new ValidationRule[]{new ValidationRule(ValidationRule.ValidationType.OneExclusive, "VEVENT", "VFREEBUSY", "VTODO", "VJOURNAL")});

    @Override
    public ValidationResult validate(Calendar target) throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        result.getEntries().addAll(PROPS_RULE_SET.apply("VCALENDAR", target));
        result.getEntries().addAll(COMPONENTS_RULE_SET.apply("VCALENDAR", target));
        return result;
    }
}

