/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fortuna.ical4j.model.PropertyContainer;
import net.fortuna.ical4j.validate.AbstractValidationRuleSet;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationRule;

public class PropertyContainerRuleSet<T extends PropertyContainer>
extends AbstractValidationRuleSet<T> {
    @SafeVarargs
    public PropertyContainerRuleSet(ValidationRule<T> ... rules) {
        super(rules);
    }

    @Override
    public List<ValidationEntry> apply(String context, T target) {
        ArrayList<ValidationEntry> results = new ArrayList<ValidationEntry>();
        for (ValidationRule rule : this.rules) {
            List<Object> matches = Collections.emptyList();
            if (rule.getPredicate().test(target)) {
                int total = rule.getInstances().stream().mapToInt(s -> target.getProperties((String)s).size()).sum();
                switch (rule.getType()) {
                    case None: {
                        matches = this.matches(rule.getInstances(), s -> target.getProperty((String)s).isPresent());
                        break;
                    }
                    case One: {
                        matches = this.matches(rule.getInstances(), s -> target.getProperties((String)s).size() != 1);
                        break;
                    }
                    case OneOrLess: {
                        matches = this.matches(rule.getInstances(), s -> target.getProperties((String)s).size() > 1);
                        break;
                    }
                    case OneOrMore: {
                        matches = this.matches(rule.getInstances(), s -> target.getProperties((String)s).size() < 1);
                        break;
                    }
                    case OneExclusive: {
                        if (!rule.getInstances().stream().anyMatch(s -> target.getProperties((String)s).size() > 0 && target.getProperties((String)s).size() != total)) break;
                        matches = rule.getInstances();
                        break;
                    }
                    case AllOrNone: {
                        if (total <= 0 || total == rule.getInstances().size()) break;
                        matches = rule.getInstances();
                    }
                }
            }
            if (matches.isEmpty()) continue;
            results.add(new ValidationEntry(rule, context, (String[])matches.toArray(String[]::new)));
        }
        return results;
    }
}

