/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.validate.AbstractValidationRuleSet;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationRule;

public class PropertyRuleSet<T extends Property>
extends AbstractValidationRuleSet<T> {
    @SafeVarargs
    public PropertyRuleSet(ValidationRule<? super T> ... rules) {
        super(rules);
    }

    @Override
    public List<ValidationEntry> apply(String context, T target) {
        ArrayList<ValidationEntry> results = new ArrayList<ValidationEntry>();
        for (ValidationRule rule : this.rules) {
            List<Object> matches = Collections.emptyList();
            if (!rule.getPredicate().test(target)) continue;
            int total = rule.getInstances().stream().mapToInt(s -> target.getParameters((String)s).size()).sum();
            switch (rule.getType()) {
                case None: {
                    matches = this.matches(rule.getInstances(), s -> target.getParameter((String)s).isPresent());
                    break;
                }
                case One: {
                    matches = this.matches(rule.getInstances(), s -> target.getParameters((String)s).size() != 1);
                    break;
                }
                case OneOrLess: {
                    matches = this.matches(rule.getInstances(), s -> target.getParameters((String)s).size() > 1);
                    break;
                }
                case OneOrMore: {
                    matches = this.matches(rule.getInstances(), s -> target.getParameters((String)s).isEmpty());
                    break;
                }
                case OneExclusive: {
                    if (!rule.getInstances().stream().anyMatch(s -> !target.getParameters((String)s).isEmpty() && target.getParameters((String)s).size() != total)) break;
                    matches = rule.getInstances();
                    break;
                }
                case AllOrNone: {
                    if (total <= 0 || total == rule.getInstances().size()) break;
                    results.add(new ValidationEntry(rule, ((Property)target).getName(), new String[0]));
                    break;
                }
                case ValueMatch: {
                    matches = this.matches(rule.getInstances(), s -> !target.getValue().matches((String)s));
                }
            }
            if (matches.isEmpty()) continue;
            results.add(new ValidationEntry(rule, ((Property)target).getName(), (String[])matches.toArray(String[]::new)));
        }
        return results;
    }
}

