/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.List;
import java.util.Optional;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.BusyType;
import net.fortuna.ical4j.model.property.Country;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.LocationType;
import net.fortuna.ical4j.model.property.Region;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.StructuredData;
import net.fortuna.ical4j.model.property.StyledDescription;
import net.fortuna.ical4j.model.property.Tel;
import net.fortuna.ical4j.model.property.Xml;
import net.fortuna.ical4j.validate.AbstractValidationRuleSet;
import net.fortuna.ical4j.validate.AbstractValidator;
import net.fortuna.ical4j.validate.PropertyRuleSet;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public final class PropertyValidator<T extends Property>
extends AbstractValidator<T> {
    public static final ValidationRule<Property> DATE_OR_DATETIME_VALUE = new ValidationRule<Property>(prop -> {
        Optional v = prop.getParameter("VALUE");
        return !v.isEmpty() && !Value.DATE.equals(v.get()) && !Value.DATE_TIME.equals(v.get());
    }, "MUST be specified as a DATE or DATE-TIME:", "VALUE");
    public static final ValidationRule<Property> BINARY_VALUE = new ValidationRule<Property>(prop -> {
        Optional v = prop.getParameter("VALUE");
        return !v.isEmpty() && !Value.BINARY.equals(v.get());
    }, "MUST be specified as a BINARY:", "VALUE");
    public static final PropertyRuleSet<DateProperty<?>> DATE_PROP_RULE_SET = new PropertyRuleSet(new ValidationRule(ValidationRule.ValidationType.OneOrLess, "VALUE", "TZID"), DATE_OR_DATETIME_VALUE);
    public static final PropertyRuleSet<Property> UTC_PROP_RULE_SET = new PropertyRuleSet(new ValidationRule(ValidationRule.ValidationType.None, "TZID"), new ValidationRule(ValidationRule.ValidationType.ValueMatch, ".+Z$"));
    public static final Validator<BusyType> BUSY_TYPE = new PropertyValidator<BusyType>("BUSYTYPE", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "(?i)" + String.join((CharSequence)"|", "BUSY", "BUSY-TENTATIVE", "BUSY-UNAVAILABLE")));
    public static final Validator<Country> COUNTRY = new PropertyValidator<Country>("COUNTRY", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ABBREV"));
    public static final Validator<LocationType> LOCATION_TYPE = new PropertyValidator<LocationType>("LOCATION-TYPE", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "LANGUAGE"));
    public static final Validator<Region> REGION = new PropertyValidator<Region>("REGION", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ABBREV"));
    public static final Validator<RequestStatus> REQUEST_STATUS = new PropertyValidator<RequestStatus>("REQUEST-STATUS", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "LANGUAGE"));
    public static final Validator<StructuredData> STRUCTURED_DATA = new PropertyValidator<StructuredData>("STRUCTURED-DATA", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "FMTTYPE", "SCHEMA"));
    public static final Validator<StyledDescription> STYLED_DESCRIPTION = new PropertyValidator<StyledDescription>("STYLED-DESCRIPTION", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ALTREP", "FMTTYPE", "LANGUAGE"));
    public static final Validator<Xml> XML = new PropertyValidator<Xml>("XML", new ValidationRule(ValidationRule.ValidationType.None, "ENCODING", "VALUE"));
    public static final Validator<Xml> XML_BIN = new PropertyValidator<Xml>("XML", new ValidationRule(ValidationRule.ValidationType.One, "VALUE", "ENCODING"), new ValidationRule<Xml>(xml -> !Optional.of(Encoding.BASE64).equals(xml.getParameter("ENCODING")), "ENCODING=BASE64 for binary attachments", "ENCODING"), BINARY_VALUE);
    public static final Validator<Tel> TEL = new PropertyValidator<Tel>("TEL", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "TYPE"));

    @SafeVarargs
    public PropertyValidator(String context, ValidationRule<? super T> ... rules) {
        super(context, new PropertyRuleSet<T>(rules));
    }

    public PropertyValidator(String context, List<PropertyRuleSet<? super T>> rulesets) {
        super(context, (AbstractValidationRuleSet[])rulesets.toArray(PropertyRuleSet[]::new));
    }
}

