/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.Validator;

public class RecurValidator
implements Validator<Recur<?>> {
    @Override
    public ValidationResult validate(Recur<?> target) throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        switch (target.getFrequency()) {
            case SECONDLY: {
                if (target.getWeekNoList().isEmpty()) break;
                result.getEntries().add(new ValidationEntry("BYWEEKNO not applicable for FREQ=SECONDLY", ValidationEntry.Severity.ERROR, "RECUR"));
                break;
            }
            case MINUTELY: {
                if (target.getWeekNoList().isEmpty()) break;
                result.getEntries().add(new ValidationEntry("BYWEEKNO not applicable for FREQ=MINUTELY", ValidationEntry.Severity.ERROR, "RECUR"));
                break;
            }
            case HOURLY: {
                if (target.getWeekNoList().isEmpty()) break;
                result.getEntries().add(new ValidationEntry("BYWEEKNO not applicable for FREQ=HOURLY", ValidationEntry.Severity.ERROR, "RECUR"));
                break;
            }
            case DAILY: {
                if (!target.getWeekNoList().isEmpty()) {
                    result.getEntries().add(new ValidationEntry("BYWEEKNO not applicable for FREQ=DAILY", ValidationEntry.Severity.ERROR, "RECUR"));
                }
                if (target.getYearDayList().isEmpty()) break;
                result.getEntries().add(new ValidationEntry("BYYEARDAY not applicable for FREQ=DAILY", ValidationEntry.Severity.ERROR, "RECUR"));
                break;
            }
            case WEEKLY: {
                if (!target.getWeekNoList().isEmpty()) {
                    result.getEntries().add(new ValidationEntry("BYWEEKNO not applicable for FREQ=WEEKLY", ValidationEntry.Severity.ERROR, "RECUR"));
                }
                if (!target.getYearDayList().isEmpty()) {
                    result.getEntries().add(new ValidationEntry("BYYEARDAY not applicable for FREQ=WEEKLY", ValidationEntry.Severity.ERROR, "RECUR"));
                }
                if (target.getMonthDayList().isEmpty()) break;
                result.getEntries().add(new ValidationEntry("BYMONTHDAY not applicable for FREQ=WEEKLY", ValidationEntry.Severity.ERROR, "RECUR"));
                break;
            }
            case MONTHLY: {
                if (!target.getWeekNoList().isEmpty()) {
                    result.getEntries().add(new ValidationEntry("BYWEEKNO not applicable for FREQ=MONTHLY", ValidationEntry.Severity.ERROR, "RECUR"));
                }
                if (target.getYearDayList().isEmpty()) break;
                result.getEntries().add(new ValidationEntry("BYYEARDAY not applicable for FREQ=MONTHLY", ValidationEntry.Severity.ERROR, "RECUR"));
            }
        }
        return result;
    }
}

