/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.Comparator;
import java.util.Objects;
import net.fortuna.ical4j.validate.ValidationRule;

public class ValidationEntry
implements Comparable<ValidationEntry> {
    private final String message;
    private final Severity severity;
    private final String context;

    public ValidationEntry(String message, Severity severity, String context) {
        this.message = message;
        this.severity = severity;
        this.context = context;
    }

    public ValidationEntry(ValidationRule<?> rule, String context, String ... instances) {
        this.message = rule.getMessage(instances);
        this.severity = rule.getSeverity();
        this.context = context;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getContext() {
        return this.context;
    }

    public String toString() {
        return "ValidationEntry{message='" + this.message + "', level=" + this.severity + ", context='" + this.context + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationEntry that = (ValidationEntry)o;
        return Objects.equals(this.message, that.message) && this.severity == that.severity && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.severity, this.context});
    }

    @Override
    public int compareTo(ValidationEntry o) {
        return Comparator.comparing(ValidationEntry::getContext).thenComparing(ValidationEntry::getSeverity).thenComparing(ValidationEntry::getMessage).compare(this, o);
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

