/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.validate.ValidationEntry;

public final class ValidationResult {
    public static final ValidationResult EMPTY = new ValidationResult(Collections.emptySet());
    private final Set<ValidationEntry> entries;

    public ValidationResult(ValidationEntry ... entries) {
        this(Arrays.asList(entries));
    }

    public ValidationResult(Collection<ValidationEntry> entries) {
        this.entries = new TreeSet<ValidationEntry>(entries);
    }

    public Set<ValidationEntry> getEntries() {
        return this.entries;
    }

    public boolean hasErrors() {
        return this.entries.stream().anyMatch(e -> e.getSeverity() == ValidationEntry.Severity.ERROR);
    }

    public ValidationResult merge(ValidationResult result) {
        if (!result.getEntries().isEmpty()) {
            TreeSet<ValidationEntry> merged = new TreeSet<ValidationEntry>(this.entries);
            merged.addAll(result.getEntries());
            return new ValidationResult(merged);
        }
        return this;
    }

    public String toString() {
        return "ValidationResult{entries=" + this.entries + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationResult that = (ValidationResult)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }
}

