/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationEntry;

public class ValidationRule<T>
implements Serializable {
    private final ValidationType type;
    private final String message;
    private final Predicate<T> predicate;
    private final List<String> instances;
    private final boolean relaxedModeSupported;

    public ValidationRule(ValidationType type, String ... instances) {
        this(type, (Predicate<Object> & Serializable)p -> true, null, false, instances);
    }

    public ValidationRule(ValidationType type, boolean relaxedModeSupported, String ... instances) {
        this(type, (Predicate<Object> & Serializable)p -> true, null, relaxedModeSupported, instances);
    }

    public ValidationRule(Predicate<T> predicate, String message, String ... instances) {
        this(ValidationType.None, predicate, message, false, instances);
    }

    public ValidationRule(Predicate<T> predicate, String message, boolean relaxedModeSupported, String ... instances) {
        this(ValidationType.None, predicate, message, relaxedModeSupported, instances);
    }

    private ValidationRule(ValidationType type, Predicate<T> predicate, String message, boolean relaxedModeSupported, String ... instances) {
        this.type = type;
        this.predicate = predicate;
        this.message = message;
        this.instances = Arrays.asList(instances);
        this.relaxedModeSupported = relaxedModeSupported;
    }

    public ValidationType getType() {
        return this.type;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public List<String> getInstances() {
        return this.instances;
    }

    public String getMessage(String ... instances) {
        List<String> match = this.getInstances();
        if (instances.length > 0) {
            match = Arrays.asList(instances);
        }
        return String.format("%s %s", this.message != null ? this.message : this.getType().getDescription(), String.join((CharSequence)",", match));
    }

    public ValidationEntry.Severity getSeverity() {
        boolean warnOnly;
        boolean bl = warnOnly = CompatibilityHints.isHintEnabled("ical4j.validation.relaxed") && this.relaxedModeSupported;
        if (warnOnly) {
            return ValidationEntry.Severity.WARNING;
        }
        return ValidationEntry.Severity.ERROR;
    }

    public static enum ValidationType {
        None("The following MUST NOT be present:"),
        One("The following are REQUIRED, but MUST NOT occur more than once:"),
        OneOrLess("The following are OPTIONAL, but MUST NOT occur more than once:"),
        OneOrMore("The following are OPTIONAL, and MAY occur more than once:"),
        OneExclusive("If one is present, ALL others MUST NOT be present:"),
        AllOrNone("If one is present, ALL must be present:"),
        ValueMatch("Value MUST match expression:");

        private final String description;

        private ValidationType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

