/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate.component;

import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.validate.ComponentContainerRuleSet;
import net.fortuna.ical4j.validate.ComponentValidator;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.ValidationRule;

@Deprecated
public class VToDoValidator
extends ComponentValidator<VToDo> {
    private static final ComponentContainerRuleSet NO_ALARMS_RULE_SET = new ComponentContainerRuleSet(new ValidationRule[]{NO_ALARMS});
    private final boolean alarmsAllowed;

    @SafeVarargs
    public VToDoValidator(ValidationRule<VToDo> ... rules) {
        this(true, rules);
    }

    @SafeVarargs
    public VToDoValidator(boolean alarmsAllowed, ValidationRule<VToDo> ... rules) {
        super("VTODO", rules);
        this.alarmsAllowed = alarmsAllowed;
    }

    @Override
    public ValidationResult validate(VToDo target) throws ValidationException {
        ValidationResult result = ComponentValidator.VTODO.validate(target);
        Optional<Status> status = target.getStatus();
        if (!(!status.isPresent() || ImmutableStatus.VTODO_NEEDS_ACTION.equals(status.get()) || ImmutableStatus.VTODO_COMPLETED.equals(status.get()) || ImmutableStatus.VTODO_IN_PROCESS.equals(status.get()) || ImmutableStatus.VTODO_CANCELLED.equals(status.get()))) {
            result.getEntries().add(new ValidationEntry("Status property [" + status + "] may not occur in VTODO", ValidationEntry.Severity.ERROR, target.getName()));
        }
        if (this.alarmsAllowed) {
            result.getEntries().addAll(target.getAlarms().stream().map(ComponentValidator.VALARM_ITIP::validate).flatMap(r -> r.getEntries().stream()).collect(Collectors.toList()));
        } else {
            result.getEntries().addAll(NO_ALARMS_RULE_SET.apply(target.getName(), target));
        }
        return result;
    }
}

