/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate.property;

import java.util.Optional;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.immutable.ImmutableAction;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public interface AlarmPropertyValidators {
    public static final Validator<Action> ACTION = new PropertyValidator<Action>("ACTION", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "(?i)" + String.join((CharSequence)"|", ImmutableAction.AUDIO.getValue(), ImmutableAction.DISPLAY.getValue(), ImmutableAction.EMAIL.getValue(), "X-[A-Z]+")));
    public static final Validator<Repeat> REPEAT = new PropertyValidator<Repeat>("REPEAT", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "[0-9]+"));
    public static final Validator<Trigger> TRIGGER_ABS = new PropertyValidator<Trigger>("TRIGGER", new ValidationRule(ValidationRule.ValidationType.One, "VALUE"), new ValidationRule(ValidationRule.ValidationType.None, "RELATED"), new ValidationRule<Trigger>(trigger -> {
        Optional v = trigger.getParameter("VALUE");
        return !v.isEmpty() && !Value.DATE_TIME.equals(v.get());
    }, "MUST be specified as a UTC-formatted DATE-TIME:", "VALUE"));
    public static final Validator<Trigger> TRIGGER_REL = new PropertyValidator<Trigger>("TRIGGER", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "VALUE", "RELATED"), new ValidationRule<Trigger>(trigger -> {
        Optional v = trigger.getParameter("VALUE");
        return !v.isEmpty() && !Value.DURATION.equals(v.get());
    }, "MUST be specified as a DURATION:", "VALUE"));
}

