/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.validate.property;

import java.util.Optional;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.immutable.ImmutableClazz;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationRule;
import net.fortuna.ical4j.validate.Validator;

public interface DescriptivePropertyValidators {
    public static final Validator<Attach> ATTACH_URI = new PropertyValidator<Attach>("ATTACH", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "FMTTYPE"));
    public static final Validator<Attach> ATTACH_BIN = new PropertyValidator<Attach>("ATTACH", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "FMTTYPE"), new ValidationRule(ValidationRule.ValidationType.One, "VALUE", "ENCODING"), new ValidationRule<Attach>(attach -> !Optional.of(Encoding.BASE64).equals(attach.getParameter("ENCODING")), "ENCODING=BASE64 for binary attachments", "ENCODING"), PropertyValidator.BINARY_VALUE);
    public static final Validator<Categories> CATEGORIES = new PropertyValidator<Categories>("CATEGORIES", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "LANGUAGE"));
    public static final Validator<Clazz> CLAZZ = new PropertyValidator<Clazz>("CLASS", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "(?i)" + String.join((CharSequence)"|", ImmutableClazz.PUBLIC.getValue(), ImmutableClazz.PRIVATE.getValue(), ImmutableClazz.CONFIDENTIAL.getValue())));
    public static final Validator<Comment> COMMENT = new PropertyValidator<Comment>("COMMENT", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ALTREP", "LANGUAGE"));
    public static final Validator<Description> DESCRIPTION = new PropertyValidator<Description>("DESCRIPTION", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ALTREP", "LANGUAGE"));
    public static final Validator<Geo> GEO = new PropertyValidator<Geo>("GEO", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "([0-9]*[.])?[0-9]+;([0-9]*[.])?[0-9]+"));
    public static final Validator<Location> LOCATION = new PropertyValidator<Location>("LOCATION", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ALTREP", "LANGUAGE"));
    public static final Validator<PercentComplete> PERCENT_COMPLETE = new PropertyValidator<PercentComplete>("PERCENT-COMPLETE", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "[0-9]{1,2}|100"));
    public static final Validator<Priority> PRIORITY = new PropertyValidator<Priority>("PRIORITY", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "[0-9]"));
    public static final Validator<Resources> RESOURCES = new PropertyValidator<Resources>("RESOURCES", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ALTREP", "LANGUAGE"));
    public static final Validator<Status> STATUS = new PropertyValidator<Status>("STATUS", new ValidationRule(ValidationRule.ValidationType.ValueMatch, "(?i)" + String.join((CharSequence)"|", ImmutableStatus.VEVENT_TENTATIVE.getValue(), ImmutableStatus.VEVENT_CONFIRMED.getValue(), ImmutableStatus.VEVENT_CANCELLED.getValue(), ImmutableStatus.VTODO_NEEDS_ACTION.getValue(), ImmutableStatus.VTODO_COMPLETED.getValue(), ImmutableStatus.VTODO_IN_PROCESS.getValue(), ImmutableStatus.VTODO_CANCELLED.getValue(), ImmutableStatus.VJOURNAL_DRAFT.getValue(), ImmutableStatus.VJOURNAL_FINAL.getValue(), ImmutableStatus.VJOURNAL_CANCELLED.getValue())));
    public static final Validator<Summary> SUMMARY = new PropertyValidator<Summary>("SUMMARY", new ValidationRule(ValidationRule.ValidationType.OneOrLess, "ALTREP", "LANGUAGE"));
}

