/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.As;
import org.mobicents.protocols.ss7.m3ua.Asp;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.State;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.AspStateEnterActive;
import org.mobicents.protocols.ss7.m3ua.impl.AspStateEnterDown;
import org.mobicents.protocols.ss7.m3ua.impl.AspStateEnterInactive;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAspDwnToAspUpSnt;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.message.MessageFactory;
import org.mobicents.protocols.ss7.m3ua.parameter.ASPIdentifier;

public class AspImpl
implements XMLSerializable,
Asp {
    private static final Logger logger = Logger.getLogger(AspImpl.class);
    protected static final String NAME = "name";
    protected String name;
    protected FSM localFSM;
    protected FSM peerFSM;
    protected AspFactoryImpl aspFactoryImpl;
    protected AsImpl asImpl;
    protected ASPIdentifier aSPIdentifier;
    private MessageFactory messageFactory = new MessageFactoryImpl();
    protected State state = AspState.DOWN;
    protected static final XMLFormat<AspImpl> ASP_XML = new XMLFormat<AspImpl>(AspImpl.class){

        public void read(XMLFormat.InputElement xml, AspImpl aspImpl) throws XMLStreamException {
            aspImpl.name = xml.getAttribute(AspImpl.NAME, "");
        }

        public void write(AspImpl aspImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(AspImpl.NAME, aspImpl.name);
        }
    };

    public AspImpl() {
    }

    public AspImpl(String name, AspFactoryImpl aspFactroy) {
        this.name = name;
        this.aspFactoryImpl = aspFactroy;
        this.init();
    }

    private void init() {
        switch (this.aspFactoryImpl.functionality) {
            case IPSP: {
                if (this.aspFactoryImpl.exchangeType == ExchangeType.SE) {
                    if (this.aspFactoryImpl.ipspType == IPSPType.CLIENT) {
                        this.initLocalFSM();
                        break;
                    }
                    this.initPeerFSM();
                    break;
                }
                this.initPeerFSM();
                this.initLocalFSM();
                break;
            }
            case AS: {
                if (this.aspFactoryImpl.exchangeType == ExchangeType.SE) {
                    this.initLocalFSM();
                    break;
                }
                this.initPeerFSM();
                this.initLocalFSM();
                break;
            }
            case SGW: {
                if (this.aspFactoryImpl.exchangeType == ExchangeType.SE) {
                    this.initPeerFSM();
                    break;
                }
                this.initPeerFSM();
                this.initLocalFSM();
            }
        }
    }

    private void initLocalFSM() {
        this.localFSM = new FSM(this.name + "_LOCAL");
        this.localFSM.createState(AspState.DOWN_SENT.toString()).setOnEnter(new AspStateEnterDown(this));
        this.localFSM.createState(AspState.DOWN.toString()).setOnEnter(new AspStateEnterDown(this));
        this.localFSM.createState(AspState.UP_SENT.toString()).setOnEnter(new AspStateEnterDown(this));
        this.localFSM.createState(AspState.INACTIVE.toString()).setOnEnter(new AspStateEnterInactive(this));
        this.localFSM.createState(AspState.ACTIVE_SENT.toString()).setOnEnter(new AspStateEnterInactive(this));
        this.localFSM.createState(AspState.ACTIVE.toString()).setOnEnter(new AspStateEnterActive(this));
        this.localFSM.createState(AspState.INACTIVE_SENT.toString()).setOnEnter(new AspStateEnterInactive(this));
        this.localFSM.setStart(AspState.DOWN.toString());
        this.localFSM.setEnd(AspState.DOWN.toString());
        this.localFSM.createTransition("commup", AspState.DOWN.toString(), AspState.UP_SENT.toString());
        this.localFSM.createTransition("commdown", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.localFSM.createTimeoutTransition(AspState.UP_SENT.toString(), AspState.UP_SENT.toString(), 2000L).setHandler(new THLocalAspDwnToAspUpSnt(this, this.localFSM));
        this.localFSM.createTransition("aspinactive", AspState.UP_SENT.toString(), AspState.INACTIVE.toString());
        this.localFSM.createTransition("aspactivesent", AspState.UP_SENT.toString(), AspState.ACTIVE_SENT.toString());
        this.localFSM.createTransition("aspdownsent", AspState.UP_SENT.toString(), AspState.DOWN_SENT.toString());
        this.localFSM.createTransition("commdown", AspState.UP_SENT.toString(), AspState.DOWN.toString());
        this.localFSM.createTimeoutTransition(AspState.ACTIVE_SENT.toString(), AspState.ACTIVE_SENT.toString(), 2000L);
        this.localFSM.createTransition("aspactiveack", AspState.ACTIVE_SENT.toString(), AspState.ACTIVE.toString());
        this.localFSM.createTransition("aspdownsent", AspState.ACTIVE_SENT.toString(), AspState.DOWN_SENT.toString());
        this.localFSM.createTransition("commdown", AspState.ACTIVE_SENT.toString(), AspState.DOWN.toString());
        this.localFSM.createTransition("aspinactivesent", AspState.ACTIVE.toString(), AspState.INACTIVE_SENT.toString());
        this.localFSM.createTransition("ntfyaltaspact", AspState.ACTIVE.toString(), AspState.INACTIVE.toString());
        this.localFSM.createTransition("aspdownsent", AspState.ACTIVE.toString(), AspState.DOWN_SENT.toString());
        this.localFSM.createTransition("commdown", AspState.ACTIVE.toString(), AspState.DOWN.toString());
        this.localFSM.createTransition("commdown", AspState.INACTIVE.toString(), AspState.DOWN.toString());
        this.localFSM.createTransition("aspactivesent", AspState.INACTIVE.toString(), AspState.ACTIVE_SENT.toString());
        this.localFSM.createTransition("aspdownsent", AspState.INACTIVE.toString(), AspState.DOWN_SENT.toString());
        this.localFSM.createTimeoutTransition(AspState.INACTIVE_SENT.toString(), AspState.INACTIVE_SENT.toString(), 2000L);
        this.localFSM.createTransition("aspinactiveack", AspState.INACTIVE_SENT.toString(), AspState.INACTIVE.toString());
        this.localFSM.createTransition("aspdownsent", AspState.INACTIVE_SENT.toString(), AspState.DOWN_SENT.toString());
        this.localFSM.createTransition("commdown", AspState.INACTIVE_SENT.toString(), AspState.DOWN.toString());
        this.localFSM.createTransition("aspdownack", AspState.DOWN_SENT.toString(), AspState.DOWN.toString());
        this.localFSM.createTransition("commdown", AspState.DOWN_SENT.toString(), AspState.DOWN.toString());
    }

    private void initPeerFSM() {
        this.peerFSM = new FSM(this.name + "_PEER");
        this.peerFSM.createState(AspState.DOWN.toString()).setOnEnter(new AspStateEnterDown(this));
        this.peerFSM.createState(AspState.ACTIVE.toString()).setOnEnter(new AspStateEnterActive(this));
        this.peerFSM.createState(AspState.INACTIVE.toString()).setOnEnter(new AspStateEnterInactive(this));
        this.peerFSM.setStart(AspState.DOWN.toString());
        this.peerFSM.setEnd(AspState.DOWN.toString());
        this.peerFSM.createTransition("commup", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("commdown", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspup", AspState.DOWN.toString(), AspState.INACTIVE.toString());
        this.peerFSM.createTransition("daud", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspactive", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspinactive", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("payload", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspdown", AspState.DOWN.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("commdown", AspState.INACTIVE.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspup", AspState.INACTIVE.toString(), AspState.INACTIVE.toString());
        this.peerFSM.createTransition("aspdown", AspState.INACTIVE.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspactive", AspState.INACTIVE.toString(), AspState.ACTIVE.toString());
        this.peerFSM.createTransition("payload", AspState.INACTIVE.toString(), AspState.INACTIVE.toString());
        this.peerFSM.createTransition("commdown", AspState.ACTIVE.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspup", AspState.ACTIVE.toString(), AspState.INACTIVE.toString());
        this.peerFSM.createTransition("aspdown", AspState.ACTIVE.toString(), AspState.DOWN.toString());
        this.peerFSM.createTransition("aspinactive", AspState.ACTIVE.toString(), AspState.INACTIVE.toString());
        this.peerFSM.createTransition("payload", AspState.ACTIVE.toString(), AspState.ACTIVE.toString());
        this.peerFSM.createTransition("ntfyaltaspact", AspState.ACTIVE.toString(), AspState.INACTIVE.toString());
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.aspFactoryImpl.started;
    }

    public boolean isConnected() {
        return this.isStarted() && this.isUp();
    }

    public boolean isUp() {
        return this.state.getName().equals("ACTIVE");
    }

    public State getState() {
        return this.state;
    }

    public FSM getLocalFSM() {
        return this.localFSM;
    }

    public FSM getPeerFSM() {
        return this.peerFSM;
    }

    public As getAs() {
        return this.asImpl;
    }

    public void setAs(AsImpl asImpl) {
        this.asImpl = asImpl;
    }

    public AspFactoryImpl getAspFactory() {
        return this.aspFactoryImpl;
    }

    public ASPIdentifier getASPIdentifier() {
        return this.aSPIdentifier;
    }

    public void setASPIdentifier(ASPIdentifier identifier) {
        this.aSPIdentifier = identifier;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }
}

