/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.ss7.m3ua.As;
import org.mobicents.protocols.ss7.m3ua.Asp;
import org.mobicents.protocols.ss7.m3ua.AspFactory;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.M3UAManagement;
import org.mobicents.protocols.ss7.m3ua.M3UAManagementEventListener;
import org.mobicents.protocols.ss7.m3ua.RouteAs;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.M3UARouteManagement;
import org.mobicents.protocols.ss7.m3ua.impl.M3UAXMLBinding;
import org.mobicents.protocols.ss7.m3ua.impl.RouteAsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.RouteMap;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.scheduler.M3UAScheduler;
import org.mobicents.protocols.ss7.m3ua.message.MessageFactory;
import org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData;
import org.mobicents.protocols.ss7.m3ua.parameter.NetworkAppearance;
import org.mobicents.protocols.ss7.m3ua.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.m3ua.parameter.ProtocolData;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPartBaseImpl;

public class M3UAManagementImpl
extends Mtp3UserPartBaseImpl
implements M3UAManagement {
    private static final Logger logger = Logger.getLogger(M3UAManagementImpl.class);
    private static final String AS_LIST = "asList";
    private static final String ASP_FACTORY_LIST = "aspFactoryList";
    private static final String DPC_VS_AS_LIST = "route";
    private static final String MAX_AS_FOR_ROUTE_PROP = "maxasforroute";
    private static final String MAX_SEQUENCE_NUMBER_PROP = "maxsequencenumber";
    private static final String HEART_BEAT_TIME_PROP = "heartbeattime";
    private static final String M3UA_PERSIST_DIR_KEY = "m3ua.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "m3ua1.xml";
    private static final M3UAXMLBinding binding = new M3UAXMLBinding();
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    protected static final int MAX_SEQUENCE_NUMBER = 256;
    protected FastList<As> appServers = new FastList();
    protected FastList<AspFactory> aspfactories = new FastList();
    protected M3UAScheduler m3uaScheduler = new M3UAScheduler();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private final String name;
    private String persistDir = null;
    protected ParameterFactory parameterFactory = new ParameterFactoryImpl();
    protected MessageFactory messageFactory = new MessageFactoryImpl();
    protected Management transportManagement = null;
    private ScheduledExecutorService fsmTicker;
    protected int maxAsForRoute = 2;
    protected int timeBetweenHeartbeat = 10000;
    private M3UARouteManagement routeManagement = null;
    protected FastList<M3UAManagementEventListener> managementEventListeners = new FastList();
    private int maxSequenceNumber = 256;

    public M3UAManagementImpl(String name, String productName) {
        super(productName);
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(AspFactoryImpl.class, "aspFactory");
        binding.setAlias(AsImpl.class, "as");
        binding.setAlias(AspImpl.class, "asp");
        this.routeManagement = new M3UARouteManagement(this);
    }

    public String getName() {
        return this.name;
    }

    public int getMaxSequenceNumber() {
        return this.maxSequenceNumber;
    }

    public void setMaxSequenceNumber(int maxSequenceNumber) throws Exception {
        if (this.isStarted) {
            throw new Exception("MaxSequenceNumber parameter can be updated only when M3UA stack is NOT running");
        }
        if (maxSequenceNumber < 1) {
            maxSequenceNumber = 1;
        } else if (maxSequenceNumber > 256) {
            maxSequenceNumber = 256;
        }
        this.maxSequenceNumber = maxSequenceNumber;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
        this.persistFile.clear();
    }

    public int getMaxAsForRoute() {
        return this.maxAsForRoute;
    }

    public void setMaxAsForRoute(int maxAsForRoute) throws Exception {
        if (this.isStarted) {
            throw new Exception("MaxAsForRoute parameter can be updated only when M3UA stack is NOT running");
        }
        if (maxAsForRoute < 1) {
            maxAsForRoute = 1;
        } else if (maxAsForRoute > 4) {
            maxAsForRoute = 4;
        }
        this.maxAsForRoute = maxAsForRoute;
    }

    public int getHeartbeatTime() {
        return this.timeBetweenHeartbeat;
    }

    public void setHeartbeatTime(int timeBetweenHeartbeat) throws Exception {
        if (!this.isStarted) {
            throw new Exception("HeartbeatTime parameter can be updated only when M3UA stack is running");
        }
        if (timeBetweenHeartbeat < 1000) {
            timeBetweenHeartbeat = 1000;
        }
        this.timeBetweenHeartbeat = timeBetweenHeartbeat;
        this.store();
    }

    public Management getTransportManagement() {
        return this.transportManagement;
    }

    public void setTransportManagement(Management transportManagement) {
        this.transportManagement = transportManagement;
    }

    public void start() throws Exception {
        if (this.transportManagement == null) {
            throw new NullPointerException("TransportManagement is null");
        }
        if (this.maxAsForRoute < 1 || this.maxAsForRoute > 4) {
            throw new Exception("Max AS for a route can be minimum 1 or maximum 4");
        }
        super.start();
        this.preparePersistFile();
        logger.info((Object)String.format("M3UA configuration file path %s", this.persistFile.toString()));
        binding.setM3uaManagement(this);
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        this.fsmTicker = Executors.newSingleThreadScheduledExecutor();
        this.fsmTicker.scheduleAtFixedRate(this.m3uaScheduler, 500L, 500L, TimeUnit.MILLISECONDS);
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onServiceStarted();
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking M3UAManagementEventListener.onServiceStarted", ee);
            }
        }
        logger.info((Object)"Started M3UAManagement");
    }

    private void preparePersistFile() {
        if (this.persistFile.length() > 0) {
            return;
        }
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(M3UA_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
    }

    public void stop() throws Exception {
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onServiceStopped();
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onServiceStopped", ee);
            }
        }
        this.store();
        this.stopFactories();
        super.stop();
        this.fsmTicker.shutdown();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addM3UAManagementEventListener(M3UAManagementEventListener m3uaManagementEventListener) {
        M3UAManagementImpl m3UAManagementImpl = this;
        synchronized (m3UAManagementImpl) {
            if (this.managementEventListeners.contains((Object)m3uaManagementEventListener)) {
                return;
            }
            FastList newManagementEventListeners = new FastList();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.add((Object)m3uaManagementEventListener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeM3UAManagementEventListener(M3UAManagementEventListener m3uaManagementEventListener) {
        M3UAManagementImpl m3UAManagementImpl = this;
        synchronized (m3UAManagementImpl) {
            if (!this.managementEventListeners.contains((Object)m3uaManagementEventListener)) {
                return;
            }
            FastList newManagementEventListeners = new FastList();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.remove((Object)m3uaManagementEventListener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    public List<As> getAppServers() {
        FastList appServersTmp = new FastList();
        appServersTmp.addAll(this.appServers);
        return appServersTmp;
    }

    public List<AspFactory> getAspfactories() {
        FastList aspfactoriesTmpe = new FastList();
        aspfactoriesTmpe.addAll(this.aspfactories);
        return aspfactoriesTmpe;
    }

    public Map<String, RouteAs> getRoute() {
        HashMap<String, RouteAs> routeTmp = new HashMap<String, RouteAs>();
        routeTmp.putAll((Map<String, RouteAs>)((Object)this.routeManagement.route));
        return routeTmp;
    }

    protected As getAs(String asName) {
        FastList.Node n = this.appServers.head();
        FastList.Node end = this.appServers.tail();
        while ((n = n.getNext()) != end) {
            As as = (As)n.getValue();
            if (!as.getName().equals(asName)) continue;
            return as;
        }
        return null;
    }

    public As createAs(String asName, Functionality functionality, ExchangeType exchangeType, IPSPType ipspType, RoutingContext rc, TrafficModeType trafficMode, int minAspActiveForLoadbalance, NetworkAppearance na) throws Exception {
        As as = this.getAs(asName);
        if (as != null) {
            throw new Exception(String.format("Creation of AS failed. Other AS with name=%s already exist", asName));
        }
        if (exchangeType == null) {
            exchangeType = ExchangeType.SE;
        }
        if (functionality == Functionality.IPSP && ipspType == null) {
            ipspType = IPSPType.CLIENT;
        }
        as = new AsImpl(asName, rc, trafficMode, minAspActiveForLoadbalance, functionality, exchangeType, ipspType, na);
        ((AsImpl)as).setM3UAManagement(this);
        FSM localFSM = ((AsImpl)as).getLocalFSM();
        this.m3uaScheduler.execute(localFSM);
        FSM peerFSM = ((AsImpl)as).getPeerFSM();
        this.m3uaScheduler.execute(peerFSM);
        this.appServers.add((Object)as);
        this.store();
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAsCreated(as);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAsCreated", ee);
            }
        }
        return as;
    }

    public AsImpl destroyAs(String asName) throws Exception {
        FSM asPeerFSM;
        AsImpl as = (AsImpl)this.getAs(asName);
        if (as == null) {
            throw new Exception(String.format("No AS found for given name %s", asName));
        }
        if (as.appServerProcs.size() != 0) {
            throw new Exception(String.format("As=%s still has ASP's assigned. Unassign Asp's before destroying this As", asName));
        }
        FastMap.Entry e = this.routeManagement.route.head();
        FastMap.Entry end = this.routeManagement.route.tail();
        while ((e = e.getNext()) != end) {
            RouteAsImpl asList = (RouteAsImpl)e.getValue();
            if (!asList.hasAs(as)) continue;
            throw new Exception(String.format("As=%s used in route=%s. Remove from route", asName, e.getKey()));
        }
        FSM asLocalFSM = as.getLocalFSM();
        if (asLocalFSM != null) {
            asLocalFSM.cancel();
        }
        if ((asPeerFSM = as.getPeerFSM()) != null) {
            asPeerFSM.cancel();
        }
        this.appServers.remove((Object)as);
        this.store();
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end2 = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end2) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAsDestroyed((As)as);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAsDestroyed", ee);
            }
        }
        return as;
    }

    public AspFactory createAspFactory(String aspName, String associationName) throws Exception {
        return this.createAspFactory(aspName, associationName, false);
    }

    public AspFactory createAspFactory(String aspName, String associationName, boolean isHeartBeatEnabled) throws Exception {
        long aspid = 0L;
        boolean regenerateFlag = true;
        block0: while (regenerateFlag) {
            aspid = AspFactoryImpl.generateId();
            if (this.aspfactories.size() == 0) break;
            FastList.Node n = this.aspfactories.head();
            FastList.Node end = this.aspfactories.tail();
            while ((n = n.getNext()) != end) {
                AspFactoryImpl aspFactoryImpl = (AspFactoryImpl)n.getValue();
                if (aspid == aspFactoryImpl.getAspid().getAspId()) {
                    regenerateFlag = true;
                    continue block0;
                }
                regenerateFlag = false;
            }
        }
        return this.createAspFactory(aspName, associationName, aspid, isHeartBeatEnabled);
    }

    public AspFactory createAspFactory(String aspName, String associationName, long aspid, boolean isHeartBeatEnabled) throws Exception {
        AspFactoryImpl factory = this.getAspFactory(aspName);
        if (factory != null) {
            throw new Exception(String.format("Creation of ASP failed. Other ASP with name=%s already exist", aspName));
        }
        Association association = this.transportManagement.getAssociation(associationName);
        if (association == null) {
            throw new Exception(String.format("No Association found for name=%s", associationName));
        }
        if (association.isStarted()) {
            throw new Exception(String.format("Association=%s is started", associationName));
        }
        if (association.getAssociationListener() != null) {
            throw new Exception(String.format("Association=%s is already associated", associationName));
        }
        FastList.Node n = this.aspfactories.head();
        FastList.Node end = this.aspfactories.tail();
        while ((n = n.getNext()) != end) {
            AspFactoryImpl aspFactoryImpl = (AspFactoryImpl)n.getValue();
            if (aspid != aspFactoryImpl.getAspid().getAspId()) continue;
            throw new Exception(String.format("ASP Identifier=%d is already taken", aspid));
        }
        factory = new AspFactoryImpl(aspName, this.getMaxSequenceNumber(), aspid, isHeartBeatEnabled);
        factory.setM3UAManagement(this);
        factory.setAssociation(association);
        factory.setTransportManagement(this.transportManagement);
        this.aspfactories.add((Object)factory);
        this.store();
        n = this.managementEventListeners.head();
        end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAspFactoryCreated((AspFactory)factory);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAspFactoryCreated", ee);
            }
        }
        return factory;
    }

    public AspFactoryImpl destroyAspFactory(String aspName) throws Exception {
        AspFactoryImpl aspFactroy = this.getAspFactory(aspName);
        if (aspFactroy == null) {
            throw new Exception(String.format("No ASP found for given name %s", aspName));
        }
        if (aspFactroy.aspList.size() != 0) {
            throw new Exception("Asp are still assigned to As. Unassign all");
        }
        aspFactroy.unsetAssociation();
        this.aspfactories.remove((Object)aspFactroy);
        this.store();
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAspFactoryDestroyed((AspFactory)aspFactroy);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAspFactoryDestroyed", ee);
            }
        }
        return aspFactroy;
    }

    public AspImpl assignAspToAs(String asName, String aspName) throws Exception {
        Asp asp;
        AsImpl asImpl = (AsImpl)this.getAs(asName);
        if (asImpl == null) {
            throw new Exception(String.format("No AS found for given name %s", asName));
        }
        AspFactoryImpl aspFactroy = this.getAspFactory(aspName);
        if (aspFactroy == null) {
            throw new Exception(String.format("No ASP found for given name %s", aspName));
        }
        FastList.Node n = asImpl.appServerProcs.head();
        FastList.Node end = asImpl.appServerProcs.tail();
        while ((n = n.getNext()) != end) {
            AspImpl aspImpl = (AspImpl)n.getValue();
            if (!aspImpl.getName().equals(aspName)) continue;
            throw new Exception(String.format("Cannot assign ASP=%s to AS=%s. This ASP is already assigned to this AS", aspName, asName));
        }
        FastList<Asp> aspImpls = aspFactroy.aspList;
        if (asImpl.getRoutingContext() == null) {
            if (aspImpls.size() != 0) {
                throw new Exception(String.format("Cannot assign ASP=%s to AS=%s. This ASP is already assigned to other AS.", aspName, asName));
            }
        } else if (aspImpls.size() > 0 && (asp = (Asp)aspImpls.get(0)) != null && asp.getAs().getRoutingContext() == null) {
            throw new Exception(String.format("Cannot assign ASP=%s to AS=%s. This ASP is already assigned to other AS which has null RoutingContext.", aspName, asName));
        }
        if (aspFactroy.getFunctionality() != null && aspFactroy.getFunctionality() != asImpl.getFunctionality()) {
            throw new Exception(String.format("Cannot assign ASP=%s to AS=%s. This ASP is already assigned to other AS of type=%s", aspName, asName, aspFactroy.getFunctionality()));
        }
        if (aspFactroy.getExchangeType() != null && aspFactroy.getExchangeType() != asImpl.getExchangeType()) {
            throw new Exception(String.format("Cannot assign ASP=%s to AS=%s. This ASP is already assigned to other AS of ExchangeType=%s", aspName, asName, aspFactroy.getExchangeType()));
        }
        if (aspFactroy.getIpspType() != null && aspFactroy.getIpspType() != asImpl.getIpspType()) {
            throw new Exception(String.format("Cannot assign ASP=%s to AS=%s. This ASP is already assigned to other AS of which has IPSP type=%s", aspName, asName, aspFactroy.getIpspType()));
        }
        aspFactroy.setExchangeType(asImpl.getExchangeType());
        aspFactroy.setFunctionality(asImpl.getFunctionality());
        aspFactroy.setIpspType(asImpl.getIpspType());
        AspImpl aspImpl = aspFactroy.createAsp();
        FSM aspLocalFSM = aspImpl.getLocalFSM();
        this.m3uaScheduler.execute(aspLocalFSM);
        FSM aspPeerFSM = aspImpl.getPeerFSM();
        this.m3uaScheduler.execute(aspPeerFSM);
        asImpl.addAppServerProcess(aspImpl);
        this.store();
        FastList.Node n2 = this.managementEventListeners.head();
        FastList.Node end2 = this.managementEventListeners.tail();
        while ((n2 = n2.getNext()) != end2) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n2.getValue();
            try {
                m3uaManagementEventListener.onAspAssignedToAs((As)asImpl, (Asp)aspImpl);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAspAssignedToAs", ee);
            }
        }
        return aspImpl;
    }

    public Asp unassignAspFromAs(String asName, String aspName) throws Exception {
        AsImpl asImpl = (AsImpl)this.getAs(asName);
        if (asImpl == null) {
            throw new Exception(String.format("No AS found for given name %s", asName));
        }
        AspImpl aspImpl = asImpl.removeAppServerProcess(aspName);
        aspImpl.getAspFactory().destroyAsp(aspImpl);
        this.store();
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAspUnassignedFromAs((As)asImpl, (Asp)aspImpl);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAspUnassignedFromAs", ee);
            }
        }
        return aspImpl;
    }

    public void startAsp(String aspName) throws Exception {
        AspFactoryImpl aspFactoryImpl = this.getAspFactory(aspName);
        if (aspFactoryImpl == null) {
            throw new Exception(String.format("No ASP found for given name %s", aspName));
        }
        if (aspFactoryImpl.getStatus()) {
            throw new Exception(String.format("ASP name=%s already started", aspName));
        }
        if (aspFactoryImpl.aspList.size() == 0) {
            throw new Exception(String.format("ASP name=%s not assigned to any AS yet", aspName));
        }
        aspFactoryImpl.start();
        this.store();
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAspFactoryStarted((AspFactory)aspFactoryImpl);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAspFactoryStarted", ee);
            }
        }
    }

    public void stopAsp(String aspName) throws Exception {
        this.doStopAsp(aspName, true);
    }

    private void doStopAsp(String aspName, boolean needStore) throws Exception {
        AspFactoryImpl aspFactoryImpl = this.getAspFactory(aspName);
        if (aspFactoryImpl == null) {
            throw new Exception(String.format("No ASP found for given name %s", aspName));
        }
        if (!aspFactoryImpl.getStatus()) {
            throw new Exception(String.format("ASP name=%s already stopped", aspName));
        }
        aspFactoryImpl.stop();
        if (needStore) {
            this.store();
        }
        FastList.Node n = this.managementEventListeners.head();
        FastList.Node end = this.managementEventListeners.tail();
        while ((n = n.getNext()) != end) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n.getValue();
            try {
                m3uaManagementEventListener.onAspFactoryStopped((AspFactory)aspFactoryImpl);
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onAspFactoryStopped", ee);
            }
        }
    }

    public void addRoute(int dpc, int opc, int si, String asName) throws Exception {
        this.routeManagement.addRoute(dpc, opc, si, asName, 2);
    }

    public void addRoute(int dpc, int opc, int si, String asName, int trafficModeType) throws Exception {
        this.routeManagement.addRoute(dpc, opc, si, asName, trafficModeType);
    }

    public void removeRoute(int dpc, int opc, int si, String asName) throws Exception {
        this.routeManagement.removeRoute(dpc, opc, si, asName);
    }

    public void removeAllResourses() throws Exception {
        FastList.Node n;
        FastList lstAsps;
        if (!this.isStarted) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (this.appServers.size() == 0 && this.aspfactories.size() == 0) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Removing allocated resources: AppServers=%d, AspFactories=%d", this.appServers.size(), this.aspfactories.size()));
        }
        this.stopFactories();
        this.routeManagement.removeAllResourses();
        FastMap lstAsAsp = new FastMap();
        for (As as : this.appServers) {
            AsImpl asImpl = (AsImpl)as;
            lstAsps = new FastList();
            n = asImpl.appServerProcs.head();
            FastList.Node end = asImpl.appServerProcs.tail();
            while ((n = n.getNext()) != end) {
                AspImpl aspImpl = (AspImpl)n.getValue();
                lstAsps.add((Object)aspImpl.getName());
            }
            lstAsAsp.put((Object)asImpl.getName(), (Object)lstAsps);
        }
        FastMap.Entry e = lstAsAsp.head();
        FastMap.Entry end = lstAsAsp.tail();
        while ((e = e.getNext()) != end) {
            String asName = (String)e.getKey();
            lstAsps = (FastList)e.getValue();
            n = lstAsps.head();
            FastList.Node end1 = lstAsps.tail();
            while ((n = n.getNext()) != end1) {
                String aspName = (String)n.getValue();
                this.unassignAspFromAs(asName, aspName);
            }
        }
        ArrayList<AspFactory> lstAspFactory = new ArrayList<AspFactory>();
        for (AspFactory aspFact : this.aspfactories) {
            lstAspFactory.add(aspFact);
        }
        for (AspFactory aspFact : lstAspFactory) {
            this.destroyAspFactory(aspFact.getName());
        }
        ArrayList<String> lst = new ArrayList<String>();
        for (As asImpl : this.appServers) {
            lst.add(asImpl.getName());
        }
        for (String n2 : lst) {
            this.destroyAs(n2);
        }
        this.store();
        FastList.Node n3 = this.managementEventListeners.head();
        FastList.Node end2 = this.managementEventListeners.tail();
        while ((n3 = n3.getNext()) != end2) {
            M3UAManagementEventListener m3uaManagementEventListener = (M3UAManagementEventListener)n3.getValue();
            try {
                m3uaManagementEventListener.onRemoveAllResources();
            }
            catch (Throwable ee) {
                logger.error((Object)"Exception while invoking onRemoveAllResources", ee);
            }
        }
    }

    private void stopFactories() throws Exception {
        boolean someFactoriesIsStopped = false;
        for (AspFactory aspFact : this.aspfactories) {
            AspFactoryImpl aspFactImpl = (AspFactoryImpl)aspFact;
            if (!aspFactImpl.started) continue;
            someFactoriesIsStopped = true;
            this.doStopAsp(aspFact.getName(), false);
        }
        if (someFactoriesIsStopped) {
            for (int step = 1; step < 50; ++step) {
                boolean allStopped = true;
                for (AspFactory aspFact : this.aspfactories) {
                    if (aspFact.getAssociation() == null || !aspFact.getAssociation().isConnected()) continue;
                    allStopped = false;
                    break;
                }
                if (allStopped) break;
                Thread.sleep(100L);
            }
        }
    }

    public void sendTransferMessageToLocalUser(Mtp3TransferPrimitive msg, int seqControl) {
        super.sendTransferMessageToLocalUser(msg, seqControl);
    }

    public void sendPauseMessageToLocalUser(Mtp3PausePrimitive msg) {
        super.sendPauseMessageToLocalUser(msg);
    }

    public void sendResumeMessageToLocalUser(Mtp3ResumePrimitive msg) {
        super.sendResumeMessageToLocalUser(msg);
    }

    public void sendStatusMessageToLocalUser(Mtp3StatusPrimitive msg) {
        super.sendStatusMessageToLocalUser(msg);
    }

    private AspFactoryImpl getAspFactory(String aspName) {
        FastList.Node n = this.aspfactories.head();
        FastList.Node end = this.aspfactories.tail();
        while ((n = n.getNext()) != end) {
            AspFactoryImpl aspFactoryImpl = (AspFactoryImpl)n.getValue();
            if (!aspFactoryImpl.getName().equals(aspName)) continue;
            return aspFactoryImpl;
        }
        return null;
    }

    public void store() {
        try {
            this.preparePersistFile();
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding((XMLBinding)binding);
            writer.setIndentation(TAB_INDENT);
            writer.write((Object)this.timeBetweenHeartbeat, HEART_BEAT_TIME_PROP, Integer.class);
            writer.write(this.aspfactories, ASP_FACTORY_LIST, FastList.class);
            writer.write(this.appServers, AS_LIST, FastList.class);
            writer.write(this.routeManagement.route, DPC_VS_AS_LIST, RouteMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        Object reader = null;
        try {
            this.preparePersistFile();
            File f = new File(this.persistFile.toString());
            if (f.exists()) {
                this.loadVer2(this.persistFile.toString());
            } else {
                String s1 = this.persistFile.toString().replace("1.xml", ".xml");
                f = new File(s1);
                if (f.exists()) {
                    this.loadVer1(s1);
                }
                this.store();
                f.delete();
            }
        }
        catch (XMLStreamException ex) {
            logger.error((Object)String.format("Failed to load the M3UA configuration file. \n%s", ex.getMessage()));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the M3UA configuration file. \n%s", e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)String.format("Failed to load the M3UA configuration file. \n%s", e.getMessage()));
        }
    }

    private void loadActualData(XMLObjectReader reader) throws XMLStreamException, IOException {
        try {
            Integer vali = (Integer)reader.read(MAX_SEQUENCE_NUMBER_PROP, Integer.class);
            vali = (Integer)reader.read(MAX_AS_FOR_ROUTE_PROP, Integer.class);
            this.timeBetweenHeartbeat = (Integer)reader.read(HEART_BEAT_TIME_PROP, Integer.class);
        }
        catch (Exception e) {
            logger.error((Object)"Errro while reading attribute", (Throwable)e);
        }
        this.aspfactories = (FastList)reader.read(ASP_FACTORY_LIST, FastList.class);
        this.appServers = (FastList)reader.read(AS_LIST, FastList.class);
        this.routeManagement.route = (RouteMap)((Object)reader.read(DPC_VS_AS_LIST, RouteMap.class));
        this.routeManagement.reset();
        FastList.Node n = this.appServers.head();
        FastList.Node end = this.appServers.tail();
        while ((n = n.getNext()) != end) {
            AsImpl asImpl = (AsImpl)n.getValue();
            asImpl.setM3UAManagement(this);
            FSM asLocalFSM = asImpl.getLocalFSM();
            this.m3uaScheduler.execute(asLocalFSM);
            FSM asPeerFSM = asImpl.getPeerFSM();
            this.m3uaScheduler.execute(asPeerFSM);
            FastList tempAsp = new FastList();
            tempAsp.addAll(asImpl.appServerProcs);
            asImpl.appServerProcs.clear();
            FastList.Node n1 = tempAsp.head();
            FastList.Node end1 = tempAsp.tail();
            while ((n1 = n1.getNext()) != end1) {
                AspImpl aspImpl = (AspImpl)n1.getValue();
                try {
                    this.assignAspToAs(asImpl.getName(), aspImpl.getName());
                }
                catch (Exception e) {
                    logger.error((Object)"Error while assigning Asp to As on loading from xml file", (Throwable)e);
                }
            }
        }
        n = this.aspfactories.head();
        end = this.aspfactories.tail();
        while ((n = n.getNext()) != end) {
            AspFactoryImpl factory = (AspFactoryImpl)n.getValue();
            factory.setTransportManagement(this.transportManagement);
            factory.setM3UAManagement(this);
            try {
                factory.setAssociation(this.transportManagement.getAssociation(factory.associationName));
            }
            catch (Throwable e1) {
                logger.error((Object)String.format("Error setting Assciation=%s for the AspFactory=%s while loading from XML", factory.associationName, factory.getName()), e1);
            }
            if (!factory.getStatus()) continue;
            try {
                factory.start();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error starting the AspFactory=%s while loading from XML", factory.getName()), (Throwable)e);
            }
        }
    }

    private void loadVer1(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("<value value=", "<routeAs trafficModeType=\"2\"  as=");
        logger.error((Object)("new XML \n" + s2.toString()));
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance((Reader)sr);
        reader.setBinding((XMLBinding)binding);
        this.loadActualData(reader);
        reader.close();
    }

    private void loadVer2(String fn) throws XMLStreamException, IOException {
        XMLObjectReader reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(fn));
        reader.setBinding((XMLBinding)binding);
        this.loadActualData(reader);
        reader.close();
    }

    public void sendMessage(Mtp3TransferPrimitive mtp3TransferPrimitive) throws IOException {
        ProtocolData data = this.parameterFactory.createProtocolData(mtp3TransferPrimitive.getOpc(), mtp3TransferPrimitive.getDpc(), mtp3TransferPrimitive.getSi(), mtp3TransferPrimitive.getNi(), mtp3TransferPrimitive.getMp(), mtp3TransferPrimitive.getSls(), mtp3TransferPrimitive.getData());
        PayloadData payload = (PayloadData)this.messageFactory.createMessage(1, 1);
        payload.setData(data);
        AsImpl asImpl = this.routeManagement.getAsForRoute(data.getDpc(), data.getOpc(), data.getSI(), data.getSLS());
        if (asImpl == null) {
            logger.error((Object)String.format("Tx : No AS found for routing message %s", payload));
            return;
        }
        payload.setNetworkAppearance(asImpl.getNetworkAppearance());
        payload.setRoutingContext(asImpl.getRoutingContext());
        asImpl.write(payload);
    }
}

