/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.fsm;

import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.Transition;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;
import org.mobicents.protocols.ss7.m3ua.impl.scheduler.M3UATask;

public class FSM
extends M3UATask {
    protected static final Logger logger = Logger.getLogger(FSM.class);
    public static final String ATTRIBUTE_MESSAGE = "message";
    private String name;
    protected FSMState start;
    protected FSMState end;
    private FastMap<String, FSMState> states = new FastMap();
    protected FSMState currentState;
    private FastMap attributes = new FastMap();
    private FSMState oldState;

    public FSM(String name) {
        this.name = name;
    }

    public FSMState getState() {
        return this.currentState;
    }

    public void setStart(String name) {
        if (this.start != null && this.currentState != null) {
            throw new IllegalStateException("Start state can't be changed now");
        }
        this.currentState = this.start = (FSMState)this.states.get((Object)name);
    }

    public void setEnd(String name) {
        this.end = (FSMState)this.states.get((Object)name);
    }

    public FSMState createState(String name) {
        FSMState s = new FSMState(this, name);
        this.states.put((Object)name, (Object)s);
        return s;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put((Object)name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get((Object)name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove((Object)name);
    }

    public Transition createTransition(String name, String from, String to) {
        if (name.equals("timeout")) {
            throw new IllegalArgumentException("timeout is illegal name for transition");
        }
        if (!this.states.containsKey((Object)from)) {
            throw new IllegalStateException("Unknown state: " + from);
        }
        if (!this.states.containsKey((Object)to)) {
            throw new IllegalStateException("Unknown state: " + to);
        }
        Transition t = new Transition(name, (FSMState)this.states.get((Object)to));
        ((FSMState)this.states.get((Object)from)).add(t);
        return t;
    }

    public Transition createTimeoutTransition(String from, String to, long timeout) {
        if (!this.states.containsKey((Object)from)) {
            throw new IllegalStateException("Unknown state: " + from);
        }
        if (!this.states.containsKey((Object)to)) {
            throw new IllegalStateException("Unknown state: " + to);
        }
        Transition t = new Transition("timeout", (FSMState)this.states.get((Object)to));
        ((FSMState)this.states.get((Object)from)).timeout = timeout;
        ((FSMState)this.states.get((Object)from)).add(t);
        return t;
    }

    public void signal(String name) throws UnknownTransitionException {
        if (this.start == null) {
            throw new IllegalStateException("The start sate is not defined");
        }
        if (this.end == null) {
            throw new IllegalStateException("The end sate is not defined");
        }
        this.oldState = this.currentState;
        this.currentState = this.currentState.signal(name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%s Transition to=%s", this.toString(), name));
        }
    }

    @Override
    public void tick(long now) {
        if (this.currentState != null) {
            this.currentState.tick(now);
        }
    }

    public String toString() {
        return String.format("FSM.name=%s old state=%s, current state=%s", this.name, this.oldState != null ? this.oldState.getName() : "", this.currentState != null ? this.currentState.getName() : "");
    }
}

