/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.parameter;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.DestinationPointCode;

public class DestinationPointCodeImpl
extends ParameterImpl
implements DestinationPointCode,
XMLSerializable {
    private static final String DPC = "dpc";
    private static final String MASK = "mask";
    private int destPC = 0;
    private short mask = 0;
    private byte[] value;
    protected static final XMLFormat<DestinationPointCodeImpl> RC_XML = new XMLFormat<DestinationPointCodeImpl>(DestinationPointCodeImpl.class){

        public void read(XMLFormat.InputElement xml, DestinationPointCodeImpl dpc) throws XMLStreamException {
            dpc.destPC = xml.getAttribute(DestinationPointCodeImpl.DPC).toInt();
            dpc.mask = (short)xml.getAttribute(DestinationPointCodeImpl.MASK).toInt();
            dpc.encode();
        }

        public void write(DestinationPointCodeImpl dpc, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(DestinationPointCodeImpl.DPC, dpc.destPC);
            xml.setAttribute(DestinationPointCodeImpl.MASK, dpc.mask);
        }
    };

    public DestinationPointCodeImpl() {
        this.tag = (short)523;
    }

    protected DestinationPointCodeImpl(byte[] value) {
        this.tag = (short)523;
        this.value = value;
        this.mask = value[0];
        this.destPC = 0;
        this.destPC |= value[1] & 0xFF;
        this.destPC <<= 8;
        this.destPC |= value[2] & 0xFF;
        this.destPC <<= 8;
        this.destPC |= value[3] & 0xFF;
    }

    protected DestinationPointCodeImpl(int pc, short mask) {
        this.tag = (short)523;
        this.destPC = pc;
        this.mask = mask;
        this.encode();
    }

    private void encode() {
        this.value = new byte[4];
        this.value[0] = (byte)this.mask;
        this.value[1] = (byte)(this.destPC >> 16);
        this.value[2] = (byte)(this.destPC >> 8);
        this.value[3] = (byte)this.destPC;
    }

    public int getPointCode() {
        return this.destPC;
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    public short getMask() {
        return this.mask;
    }

    public String toString() {
        return String.format("DestinationPointCode dpc=%d mask=%d", this.destPC, this.mask);
    }
}

