/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.parameter;

import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.ProtocolData;

public class ProtocolDataImpl
extends ParameterImpl
implements ProtocolData {
    private int opc;
    private int dpc;
    private int si;
    private int ni;
    private int mp;
    private int sls;
    private byte[] data;

    protected ProtocolDataImpl() {
        this.tag = (short)528;
    }

    protected ProtocolDataImpl(int opc, int dpc, int si, int ni, int mp, int sls, byte[] data) {
        this();
        this.opc = opc;
        this.dpc = dpc;
        this.si = si;
        this.ni = ni;
        this.mp = mp;
        this.sls = sls;
        this.data = data;
        this.encode();
    }

    protected ProtocolDataImpl(byte[] valueData) {
        this();
        this.opc = (valueData[0] & 0xFF) << 24 | (valueData[1] & 0xFF) << 16 | (valueData[2] & 0xFF) << 8 | valueData[3] & 0xFF;
        this.dpc = (valueData[4] & 0xFF) << 24 | (valueData[5] & 0xFF) << 16 | (valueData[6] & 0xFF) << 8 | valueData[7] & 0xFF;
        this.si = valueData[8] & 0xFF;
        this.ni = valueData[9] & 0xFF;
        this.mp = valueData[10] & 0xFF;
        this.sls = valueData[11] & 0xFF;
        this.data = new byte[valueData.length - 12];
        System.arraycopy(valueData, 12, this.data, 0, valueData.length - 12);
    }

    private byte[] encode() {
        byte[] value = new byte[this.data.length + 12];
        System.arraycopy(this.data, 0, value, 12, this.data.length);
        value[0] = (byte)(this.opc >> 24);
        value[1] = (byte)(this.opc >> 16);
        value[2] = (byte)(this.opc >> 8);
        value[3] = (byte)this.opc;
        value[4] = (byte)(this.dpc >> 24);
        value[5] = (byte)(this.dpc >> 16);
        value[6] = (byte)(this.dpc >> 8);
        value[7] = (byte)this.dpc;
        value[8] = (byte)this.si;
        value[9] = (byte)this.ni;
        value[10] = (byte)this.mp;
        value[11] = (byte)this.sls;
        return value;
    }

    public int getOpc() {
        return this.opc;
    }

    public int getDpc() {
        return this.dpc;
    }

    public int getSI() {
        return this.si;
    }

    public int getNI() {
        return this.ni;
    }

    public int getMP() {
        return this.mp;
    }

    public int getSLS() {
        return this.sls;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected byte[] getValue() {
        return this.encode();
    }

    public String toString() {
        return String.format("Protocol opc=%d dpc=%d si=%d ni=%d sls=%d", this.opc, this.dpc, this.si, this.ni, this.sls);
    }
}

