/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.client.serialization.model.TimesDTO;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ModelObject;

public class ExpectationDTO
extends ModelObject {
    private HttpRequestDTO httpRequest;
    private HttpResponseDTO httpResponse;
    private TimesDTO times;

    public ExpectationDTO(Expectation expectation) {
        if (expectation.getHttpRequest() != null) {
            this.httpRequest = new HttpRequestDTO(expectation.getHttpRequest());
        }
        if (expectation.getHttpResponse() != null) {
            this.httpResponse = new HttpResponseDTO(expectation.getHttpResponse());
        }
        if (expectation.getTimes() != null) {
            this.times = new TimesDTO(expectation.getTimes());
        }
    }

    public ExpectationDTO() {
    }

    public Expectation buildObject() {
        HttpResponse httpResponse = null;
        if (this.httpRequest == null) {
            this.logger.warn("HttpRequest must be specified to create an Expectation");
            throw new IllegalArgumentException("HttpRequest must be specified to create an Expectation");
        }
        HttpRequest httpRequest = this.httpRequest.buildObject();
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        Times times = this.times != null ? this.times.buildObject() : Times.unlimited();
        return new Expectation(httpRequest, times).respond(httpResponse);
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public ExpectationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public TimesDTO getTimes() {
        return this.times;
    }

    public ExpectationDTO setTimes(TimesDTO times) {
        this.times = times;
        return this;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public ExpectationDTO setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }
}

