/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.model.CookieDTO;
import org.mockserver.client.serialization.model.HeaderDTO;
import org.mockserver.client.serialization.model.ParameterDTO;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ModelObject;
import org.mockserver.model.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestDTO
extends ModelObject {
    private String method;
    private String path;
    private String body;
    private List<CookieDTO> cookies = new ArrayList<CookieDTO>();
    private List<HeaderDTO> headers = new ArrayList<HeaderDTO>();
    private List<ParameterDTO> parameters = new ArrayList<ParameterDTO>();

    public HttpRequestDTO(HttpRequest httpRequest) {
        this.method = httpRequest.getMethod();
        this.path = httpRequest.getPath();
        this.body = httpRequest.getBody();
        this.headers = Lists.transform(httpRequest.getHeaders(), (Function)new Function<Header, HeaderDTO>(){

            public HeaderDTO apply(Header header) {
                return new HeaderDTO(header);
            }
        });
        this.cookies = Lists.transform(httpRequest.getCookies(), (Function)new Function<Cookie, CookieDTO>(){

            public CookieDTO apply(Cookie cookie) {
                return new CookieDTO(cookie);
            }
        });
        this.parameters = Lists.transform(httpRequest.getParameters(), (Function)new Function<Parameter, ParameterDTO>(){

            public ParameterDTO apply(Parameter parameter) {
                return new ParameterDTO(parameter);
            }
        });
    }

    public HttpRequestDTO() {
    }

    public HttpRequest buildObject() {
        return new HttpRequest().withMethod(this.method).withPath(this.path).withBody(this.body).withHeaders(Lists.transform(this.headers, (Function)new Function<HeaderDTO, Header>(){

            public Header apply(HeaderDTO header) {
                return header.buildObject();
            }
        })).withCookies(Lists.transform(this.cookies, (Function)new Function<CookieDTO, Cookie>(){

            public Cookie apply(CookieDTO cookie) {
                return cookie.buildObject();
            }
        })).withParameters(Lists.transform(this.parameters, (Function)new Function<ParameterDTO, Parameter>(){

            public Parameter apply(ParameterDTO parameter) {
                return parameter.buildObject();
            }
        }));
    }

    public String getMethod() {
        return this.method;
    }

    public HttpRequestDTO setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequestDTO setPath(String path) {
        this.path = path;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public HttpRequestDTO setBody(String body) {
        this.body = body;
        return this;
    }

    public List<HeaderDTO> getHeaders() {
        return this.headers;
    }

    public HttpRequestDTO setHeaders(List<HeaderDTO> headers) {
        this.headers = headers;
        return this;
    }

    public List<ParameterDTO> getParameters() {
        return this.parameters;
    }

    public HttpRequestDTO setParameters(List<ParameterDTO> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<CookieDTO> getCookies() {
        return this.cookies;
    }

    public HttpRequestDTO setCookies(List<CookieDTO> cookies) {
        this.cookies = cookies;
        return this;
    }
}

