/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.ArrayList;
import java.util.List;
import org.mockserver.matchers.MapMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.StringMatcher;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.ModelObject;
import org.mockserver.model.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestMatcher
extends ModelObject
implements Matcher<HttpRequest> {
    private StringMatcher methodMatcher = null;
    private StringMatcher pathMatcher = null;
    private StringMatcher bodyMatcher = null;
    private MapMatcher headerMatcher = null;
    private MapMatcher parameterMatcher = null;
    private MapMatcher cookieMatcher = null;

    public HttpRequestMatcher withMethod(String method) {
        this.methodMatcher = new StringMatcher(method);
        return this;
    }

    public HttpRequestMatcher withPath(String path) {
        this.pathMatcher = new StringMatcher(path);
        return this;
    }

    public HttpRequestMatcher withBody(String body) {
        this.bodyMatcher = new StringMatcher(body);
        return this;
    }

    public HttpRequestMatcher withHeaders(Header ... headers) {
        this.headerMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    public HttpRequestMatcher withHeaders(List<Header> headers) {
        this.headerMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    public HttpRequestMatcher withParameters(Parameter ... parameters) {
        this.parameterMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(parameters));
        return this;
    }

    public HttpRequestMatcher withParameters(List<Parameter> parameters) {
        this.parameterMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(parameters));
        return this;
    }

    public HttpRequestMatcher withCookies(Cookie ... cookies) {
        this.cookieMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(cookies));
        return this;
    }

    public HttpRequestMatcher withCookies(List<Cookie> cookies) {
        this.cookieMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(cookies));
        return this;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        boolean methodMatches = this.matches(this.methodMatcher, httpRequest.getMethod());
        boolean pathMatches = this.matches(this.pathMatcher, httpRequest.getPath());
        boolean bodyMatches = this.matches(this.bodyMatcher, httpRequest.getBody());
        boolean headersMatch = this.matches(this.headerMatcher, httpRequest.getHeaders() != null ? new ArrayList<Header>(httpRequest.getHeaders()) : null);
        boolean parametersMatch = this.matches(this.parameterMatcher, httpRequest.getParameters() != null ? new ArrayList<Parameter>(httpRequest.getParameters()) : null);
        boolean cookiesMatch = this.matches(this.cookieMatcher, httpRequest.getCookies() != null ? new ArrayList<Cookie>(httpRequest.getCookies()) : null);
        return methodMatches && pathMatches && bodyMatches && headersMatch && parametersMatch && cookiesMatch;
    }

    private <T> boolean matches(Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(t)) {
            result = true;
        }
        return result;
    }
}

