/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMatcher
extends ModelObject
implements Matcher<List<KeyToMultiValue>> {
    private final Multimap<String, String> multimap;

    public MapMatcher(Multimap<String, String> multimap) {
        this.multimap = multimap;
    }

    @Override
    public boolean matches(List<KeyToMultiValue> values) {
        boolean result = false;
        if (this.containsAll(KeyToMultiValue.toMultiMap(values), this.multimap)) {
            result = true;
        } else {
            this.logger.trace("Map [{}] is not a subset of [{}]", this.multimap, KeyToMultiValue.toMultiMap(values));
        }
        return result;
    }

    private boolean containsAll(Multimap<String, String> superset, Multimap<String, String> subset) {
        for (String key : subset.keySet()) {
            for (String value : subset.get((Object)key)) {
                boolean regexMatches = false;
                if (!superset.containsKey((Object)key)) {
                    return false;
                }
                for (String supersetValue : superset.get((Object)key)) {
                    try {
                        if (!supersetValue.matches(value)) continue;
                        regexMatches = true;
                    }
                    catch (PatternSyntaxException pse) {
                        this.logger.error("Error while matching regex [" + value + "] for string [" + supersetValue + "] " + pse.getMessage());
                    }
                }
                if (!regexMatches) {
                    return false;
                }
                if (regexMatches || superset.containsEntry((Object)key, (Object)value)) continue;
                return false;
            }
        }
        return true;
    }
}

