/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Strings;
import java.util.regex.PatternSyntaxException;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMatcher
extends ModelObject
implements Matcher<String> {
    private final String path;

    public StringMatcher(String path) {
        this.path = path;
    }

    @Override
    public boolean matches(String path) {
        boolean result = false;
        if (Strings.isNullOrEmpty((String)this.path)) {
            result = true;
        } else if (path != null) {
            try {
                if (path.matches(this.path)) {
                    result = true;
                }
            }
            catch (PatternSyntaxException pse) {
                this.logger.error("Error while matching regex [" + this.path + "] for string [" + path + "] " + pse.getMessage());
            }
            try {
                if (this.path.matches(path)) {
                    result = true;
                }
            }
            catch (PatternSyntaxException pse) {
                this.logger.error("Error while matching regex [" + path + "] for string [" + this.path + "] " + pse.getMessage());
            }
        }
        if (!result) {
            this.logger.trace("Failed to match [{}] with [{}]", (Object)path, (Object)this.path);
        }
        return result;
    }
}

