/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import org.mockserver.mappers.ExpectationMapper;
import org.mockserver.matchers.Times;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ModelObject;

public class Expectation
extends ModelObject {
    public static final ExpectationMapper EXPECTATION_MAPPER = new ExpectationMapper();
    private final HttpRequest httpRequest;
    private final Times times;
    private HttpResponse httpResponse;

    public Expectation(HttpRequest httpRequest, Times times) {
        this.httpRequest = httpRequest;
        this.times = times;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse != null ? this.httpResponse.applyDelay() : null;
    }

    public Times getTimes() {
        return this.times;
    }

    public Expectation respond(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public boolean matches(HttpRequest httpRequest) {
        boolean matches;
        this.logger.trace("\nMatching expectation: \n{} \nwith incoming request: \n{}\n", (Object)this.httpRequest, (Object)httpRequest);
        boolean bl = matches = this.times.greaterThenZero() && EXPECTATION_MAPPER.transformsToMatcher(this.httpRequest).matches(httpRequest);
        if (matches) {
            this.times.decrement();
        }
        return matches;
    }

    public void setNotUnlimitedResponses() {
        this.times.setNotUnlimitedResponses();
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }
}

