/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.ModelObject;
import org.mockserver.model.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends ModelObject {
    private String method = "";
    private String path = "";
    private String body = "";
    private List<Header> headers = new ArrayList<Header>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Cookie> cookies = new ArrayList<Cookie>();

    public HttpRequest withMethod(String method) {
        this.method = method;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequest withPath(String path) {
        this.path = path;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public HttpRequest withBody(String body) {
        this.body = body;
        return this;
    }

    public HttpRequest withHeaders(List<Header> headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest withHeaders(Header ... headers) {
        this.headers = Arrays.asList(headers);
        return this;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public HttpRequest withCookies(List<Cookie> cookies) {
        this.cookies = cookies;
        return this;
    }

    public HttpRequest withCookies(Cookie ... cookies) {
        this.cookies = Arrays.asList(cookies);
        return this;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public HttpRequest withParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public HttpRequest withParameters(Parameter ... parameters) {
        this.parameters = Arrays.asList(parameters);
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }
}

