/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockserver.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyToMultiValue
extends ModelObject {
    private final String name;
    private final List<String> values;

    public KeyToMultiValue(String name, String ... values) {
        this(name, Arrays.asList(values));
    }

    public KeyToMultiValue(String name, List<String> values) {
        this.name = name;
        this.values = values != null ? values : new ArrayList<String>();
    }

    public static Multimap<String, String> toMultiMap(List<? extends KeyToMultiValue> keyToMultiValues) {
        HashMultimap headersMap = HashMultimap.create();
        for (KeyToMultiValue keyToMultiValue : keyToMultiValues) {
            for (String value : keyToMultiValue.getValues()) {
                headersMap.put((Object)keyToMultiValue.getName(), (Object)value);
            }
        }
        return headersMap;
    }

    public static Multimap<String, String> toMultiMap(KeyToMultiValue ... keyToMultiValues) {
        return KeyToMultiValue.toMultiMap(Arrays.asList(keyToMultiValues));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return this.values;
    }
}

