/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.client.serialization.java.HttpCallbackToJavaSerializer;
import org.mockserver.client.serialization.java.HttpErrorToJavaSerializer;
import org.mockserver.client.serialization.java.HttpForwardToJavaSerializer;
import org.mockserver.client.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.client.serialization.java.HttpResponseToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.mock.Expectation;

public class ExpectationToJavaSerializer
implements ToJavaSerializer<Expectation> {
    public static final int INDENT_SIZE = 8;

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, Expectation expectation) {
        StringBuffer output = new StringBuffer();
        if (expectation != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("new MockServerClient(\"localhost\", 1080)");
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".when(");
            output.append(new HttpRequestToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 1, expectation.getHttpRequest())).append(",");
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append("Times.once()");
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            if (expectation.getHttpResponse(false) != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".respond(");
                output.append(new HttpResponseToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 1, expectation.getHttpResponse(false)));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpForward() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpForwardToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 1, expectation.getHttpForward()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpError() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".error(");
                output.append(new HttpErrorToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 1, expectation.getHttpError()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".callback(");
                output.append(new HttpCallbackToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 1, expectation.getHttpCallback()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            output.append(";");
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

