/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.mockserver.streams.IOStreamUtils;

public class MockServerResponseToHttpServletResponseEncoder {
    public void mapMockServerResponseToHttpServletResponse(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        this.setStatusCode(httpResponse, httpServletResponse);
        this.setHeaders(httpResponse, httpServletResponse);
        this.setCookies(httpResponse, httpServletResponse);
        this.setBody(httpResponse, httpServletResponse);
    }

    private void setStatusCode(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getStatusCode() != null) {
            httpServletResponse.setStatus(httpResponse.getStatusCode().intValue());
        } else {
            httpServletResponse.setStatus(200);
        }
    }

    private void setHeaders(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getHeaders() != null) {
            for (Header header : httpResponse.getHeaders()) {
                String headerName = header.getName().getValue();
                if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Transfer-Encoding") || headerName.equalsIgnoreCase("Host") || headerName.equalsIgnoreCase("Accept-Encoding") || headerName.equalsIgnoreCase("Connection")) continue;
                for (NottableString value : header.getValues()) {
                    httpServletResponse.addHeader(headerName, value.getValue());
                }
            }
        }
        this.addContentTypeHeader(httpResponse, httpServletResponse);
    }

    private void setCookies(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getCookies() != null) {
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookies()) {
                if (this.cookieHeaderAlreadyExists(httpResponse, cookie)) continue;
                httpServletResponse.addHeader("Set-Cookie", ServerCookieEncoder.LAX.encode((Cookie)new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue())));
            }
        }
    }

    private boolean cookieHeaderAlreadyExists(HttpResponse response, org.mockserver.model.Cookie cookieValue) {
        List<String> setCookieHeaders = response.getHeader("Set-Cookie");
        setCookieHeaders.addAll(response.getHeader("Set-Cookie".toLowerCase()));
        for (String setCookieHeader : setCookieHeaders) {
            String existingCookieName = ClientCookieDecoder.LAX.decode(setCookieHeader).name();
            String existingCookieValue = ClientCookieDecoder.LAX.decode(setCookieHeader).value();
            if (!existingCookieName.equalsIgnoreCase(cookieValue.getName().getValue()) || !existingCookieValue.equalsIgnoreCase(cookieValue.getValue().getValue())) continue;
            return true;
        }
        return false;
    }

    private void setBody(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getBodyAsString() != null) {
            if (httpResponse.getBody() instanceof BinaryBody) {
                IOStreamUtils.writeToOutputStream(Base64Converter.base64StringToBytes(httpResponse.getBodyAsString()), (ServletResponse)httpServletResponse);
            } else {
                Charset bodyCharset = httpResponse.getBody().getCharset(ContentTypeMapper.determineCharsetForMessage(httpResponse));
                IOStreamUtils.writeToOutputStream(httpResponse.getBodyAsString().getBytes(bodyCharset), (ServletResponse)httpServletResponse);
            }
        }
    }

    private void addContentTypeHeader(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpServletResponse.getContentType() == null && httpResponse.getBody() != null) {
            Charset bodyCharset = httpResponse.getBody().getCharset(null);
            String bodyContentType = httpResponse.getBody().getContentType();
            if (bodyCharset != null) {
                httpServletResponse.addHeader("Content-Type", bodyContentType + "; charset=" + bodyCharset.name().toLowerCase());
            } else if (bodyContentType != null) {
                httpServletResponse.addHeader("Content-Type", bodyContentType);
            }
        }
    }
}

