/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.mockserver.model.Not;

public class NottableString
extends Not {
    private final String value;

    private NottableString(String value, Boolean not) {
        this.value = value;
        this.not = not;
    }

    public static NottableString string(String value, Boolean not) {
        return new NottableString(value, not);
    }

    public static NottableString string(String value) {
        return new NottableString(value, null);
    }

    public static NottableString not(String value) {
        return new NottableString(value, Boolean.TRUE);
    }

    public static List<NottableString> strings(String ... values) {
        return NottableString.strings(Arrays.asList(values));
    }

    public static List<NottableString> strings(Collection<String> values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof String) {
            return this.isNot() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            NottableString otherNottableString = (NottableString)other;
            if (otherNottableString.getValue() == null) {
                return this.value == null;
            }
            return otherNottableString.isNot() == (this.isNot() == otherNottableString.getValue().equals(this.value));
        }
        return false;
    }
}

