/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLFactory.class);
    private static final String PROVIDER_NAME = "BC";
    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSAEncryption";
    private static final String KEY_GENERATION_ALGORITHM = "RSA";
    private static final boolean REGENERATE_FRESH_CA_CERTIFICATE = false;
    private static final int ROOT_KEYSIZE = 2048;
    private static final int FAKE_KEYSIZE = 1024;
    private static final Date NOT_BEFORE;
    private static final Date NOT_AFTER;

    public static KeyPair generateKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_GENERATION_ALGORITHM, PROVIDER_NAME);
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) throws IOException {
        SubjectKeyIdentifier subjectKeyIdentifier;
        ASN1InputStream is = null;
        try {
            is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(seq);
            subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return subjectKeyIdentifier;
    }

    private static X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey signedWithPrivateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER_NAME).build(signedWithPrivateKey);
        return new JcaX509CertificateConverter().setProvider(PROVIDER_NAME).getCertificate(certificateBuilder.build(signer));
    }

    public X509Certificate createCACert(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        X500Name issuerName;
        X500Name subjectName = issuerName = new X500Name("CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt());
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serial, NOT_BEFORE, NOT_AFTER, subjectName, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)KeyStoreFactory.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        KeyUsage usage = new KeyUsage(182);
        builder.addExtension(Extension.keyUsage, false, (ASN1Encodable)usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        X509Certificate cert = KeyStoreFactory.signCertificate((X509v3CertificateBuilder)builder, privateKey);
        cert.checkValidity(new Date());
        cert.verify(publicKey);
        return cert;
    }

    public X509Certificate createClientCert(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey, String domain, String[] subjectAlternativeNameDomains, String[] subjectAlternativeNameIps) throws Exception {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + domain + ", O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt());
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, NOT_BEFORE, NOT_AFTER, subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)KeyStoreFactory.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        ArrayList<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
        if (subjectAlternativeNameDomains != null) {
            subjectAlternativeNames.add(new GeneralName(2, domain));
            for (String subjectAlternativeNameDomain : subjectAlternativeNameDomains) {
                subjectAlternativeNames.add(new GeneralName(2, subjectAlternativeNameDomain));
            }
        }
        if (subjectAlternativeNameIps != null) {
            for (String subjectAlternativeNameIp : subjectAlternativeNameIps) {
                if (!IPAddress.isValidIPv6WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv6((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4((String)subjectAlternativeNameIp)) continue;
                subjectAlternativeNames.add(new GeneralName(7, subjectAlternativeNameIp));
            }
        }
        if (subjectAlternativeNames.size() > 0) {
            DERSequence subjectAlternativeNamesExtension = new DERSequence(subjectAlternativeNames.toArray(new ASN1Encodable[subjectAlternativeNames.size()]));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        }
        X509Certificate cert = KeyStoreFactory.signCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
        cert.checkValidity(new Date());
        cert.verify(certificateAuthorityPublicKey);
        return cert;
    }

    KeyStore generateCertificate(KeyStore keyStore, String certificationAlias, String certificateAuthorityAlias, char[] keyStorePassword, String domain, String[] subjectAlternativeNameDomains, String[] subjectAlternativeNameIps) throws Exception {
        KeyPair keyPair = KeyStoreFactory.generateKeyPair(1024);
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        RSAPrivateKey caPrivateKey = this.loadPrivateKeyFromPEMFile("org/mockserver/socket/CertificateAuthorityPrivateKey.pem");
        X509Certificate caCert = (X509Certificate)this.loadCertificateFromKeyStore("org/mockserver/socket/CertificateAuthorityKeyStore.jks", certificateAuthorityAlias, keyStorePassword);
        X509Certificate clientCert = this.createClientCert(publicKey, caCert, caPrivateKey, caCert.getPublicKey(), domain, subjectAlternativeNameDomains, subjectAlternativeNameIps);
        return this.saveCertificateAsKeyStore(keyStore, ConfigurationProperties.deleteGeneratedKeyStoreOnExit(), ConfigurationProperties.javaKeyStoreFilePath(), certificationAlias, privateKey, keyStorePassword, new X509Certificate[]{clientCert, caCert}, caCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCertificateAsPEMFile(Object x509Certificate, String filename) throws IOException {
        FileWriter fileWriter = new FileWriter(filename);
        JcaPEMWriter jcaPEMWriter = null;
        try {
            jcaPEMWriter = new JcaPEMWriter((Writer)fileWriter);
            jcaPEMWriter.writeObject(x509Certificate);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jcaPEMWriter);
            IOUtils.closeQuietly((Writer)fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)jcaPEMWriter);
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore saveCertificateAsKeyStore(KeyStore existingKeyStore, boolean deleteOnExit, String keyStoreFileName, String certificationAlias, Key privateKey, char[] keyStorePassword, Certificate[] chain, X509Certificate caCert) {
        try {
            KeyStore keyStore = existingKeyStore;
            if (keyStore == null) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, keyStorePassword);
            }
            try {
                keyStore.deleteEntry(certificationAlias);
            }
            catch (KeyStoreException kse) {
                // empty catch block
            }
            keyStore.setKeyEntry(certificationAlias, privateKey, keyStorePassword, chain);
            try {
                keyStore.deleteEntry("mockserver-ca-cert");
            }
            catch (KeyStoreException kse) {
                // empty catch block
            }
            keyStore.setCertificateEntry("mockserver-ca-cert", caCert);
            File keyStoreFile = new File(keyStoreFileName);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(keyStoreFile);
                keyStore.store(fileOutputStream, keyStorePassword);
                logger.trace("Saving key store to file [" + keyStoreFileName + "]");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            if (deleteOnExit) {
                keyStoreFile.deleteOnExit();
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while saving KeyStore", e);
        }
    }

    private RSAPrivateKey loadPrivateKeyFromPEMFile(String privateKeyFileName) {
        try {
            String publicKeyFile = IOUtils.toString((Reader)new InputStreamReader(KeyStoreFactory.class.getClassLoader().getResourceAsStream(privateKeyFileName)));
            byte[] publicKeyBytes = DatatypeConverter.parseBase64Binary((String)publicKeyFile.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", ""));
            return (RSAPrivateKey)KeyFactory.getInstance(KEY_GENERATION_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(publicKeyBytes));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception reading private key from PEM file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate loadCertificateFromKeyStore(String keyStoreFileName, String certificationAlias, char[] keyStorePassword) {
        Certificate certificate;
        InputStream inputStream = this.readFileFromClassPathOrPath(keyStoreFileName);
        try {
            logger.trace("Loading key store from file [" + keyStoreFileName + "]");
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(inputStream, keyStorePassword);
            certificate = keystore.getCertificate(certificationAlias);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while loading KeyStore from " + keyStoreFileName, e);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return certificate;
    }

    private InputStream readFileFromClassPathOrPath(String keyStoreFileName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(keyStoreFileName);
        if (inputStream == null) {
            inputStream = new FileInputStream(keyStoreFileName);
        }
        return inputStream;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
        NOT_AFTER = new Date(System.currentTimeMillis() + 3153600000000L);
    }
}

