/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;

public class MockServerResponseDecoder
extends MessageToMessageDecoder<FullHttpResponse> {
    protected void decode(ChannelHandlerContext ctx, FullHttpResponse fullHttpResponse, List<Object> out) {
        HttpResponse httpResponse = new HttpResponse();
        if (fullHttpResponse != null) {
            this.setStatusCode(httpResponse, fullHttpResponse);
            this.setHeaders(httpResponse, fullHttpResponse);
            this.setCookies(httpResponse);
            this.setBody(httpResponse, fullHttpResponse);
        }
        out.add(httpResponse);
    }

    private void setStatusCode(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        httpResponse.withStatusCode(fullHttpResponse.getStatus().code());
    }

    private void setHeaders(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        HashMap<String, Header> mappedHeaders = new HashMap<String, Header>();
        for (String headerName : fullHttpResponse.headers().names()) {
            mappedHeaders.put(headerName, new Header(headerName, fullHttpResponse.headers().getAll(headerName)));
        }
        ArrayList<Header> headers = new ArrayList<Header>(mappedHeaders.values());
        httpResponse.withHeaders(headers);
    }

    private void setCookies(HttpResponse httpResponse) {
        HashMap<String, org.mockserver.model.Cookie> mappedCookies = new HashMap<String, org.mockserver.model.Cookie>();
        for (Header header : httpResponse.getHeaders()) {
            if (header.getName().getValue().equalsIgnoreCase("Set-Cookie")) {
                for (NottableString cookieHeader : header.getValues()) {
                    Cookie httpCookie = ClientCookieDecoder.LAX.decode(cookieHeader.getValue());
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value().trim();
                    mappedCookies.put(name, new org.mockserver.model.Cookie(name, value));
                }
            }
            if (!header.getName().getValue().equalsIgnoreCase("Cookie")) continue;
            for (NottableString cookieHeader : header.getValues()) {
                for (Cookie httpCookie : ServerCookieDecoder.LAX.decode(cookieHeader.getValue())) {
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value().trim();
                    mappedCookies.put(name, new org.mockserver.model.Cookie(name, value));
                }
            }
        }
        httpResponse.withCookies(new ArrayList<org.mockserver.model.Cookie>(mappedCookies.values()));
    }

    private void setBody(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            if (bodyBytes.length > 0) {
                if (ContentTypeMapper.isBinary(fullHttpResponse.headers().get("Content-Type"))) {
                    httpResponse.withBody(new BinaryBody(bodyBytes));
                } else {
                    Charset requestCharset = ContentTypeMapper.determineCharsetForMessage((HttpMessage)fullHttpResponse);
                    httpResponse.withBody(new String(bodyBytes, requestCharset));
                }
            }
        }
    }
}

