/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.java.CookieToJavaSerializer;
import org.mockserver.client.serialization.java.HeaderToJavaSerializer;
import org.mockserver.client.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.client.serialization.java.ParameterToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;

public class HttpRequestToJavaSerializer
implements ToJavaSerializer<HttpRequest> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, HttpRequest httpRequest) {
        StringBuffer output = new StringBuffer();
        if (httpRequest != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("request()");
            if (httpRequest.getMethod() != null && StringUtils.isNotEmpty((CharSequence)httpRequest.getMethod().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withMethod(\"").append(httpRequest.getMethod().getValue()).append("\")");
            }
            if (httpRequest.getPath() != null && StringUtils.isNotEmpty((CharSequence)httpRequest.getPath().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withPath(\"").append(httpRequest.getPath().getValue()).append("\")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, httpRequest.getHeaders());
            this.outputCookies(numberOfSpacesToIndent + 1, output, httpRequest.getCookies());
            this.outputParameters(numberOfSpacesToIndent + 1, output, "QueryStringParameter", httpRequest.getQueryStringParameters());
            if (httpRequest.isSecure() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withSecure(").append(httpRequest.isSecure().toString()).append(")");
            }
            if (httpRequest.isKeepAlive() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withKeepAlive(").append(httpRequest.isKeepAlive().toString()).append(")");
            }
            if (httpRequest.getBody() != null) {
                if (httpRequest.getBody() instanceof JsonBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonBody jsonBody = (JsonBody)httpRequest.getBody();
                    output.append("new JsonBody(\"").append(StringEscapeUtils.escapeJava((String)jsonBody.getValue())).append("\", JsonBodyMatchType.").append((Object)jsonBody.getMatchType()).append(")");
                    output.append(")");
                } else if (httpRequest.getBody() instanceof JsonSchemaBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)httpRequest.getBody();
                    output.append("new JsonSchemaBody(\"").append(StringEscapeUtils.escapeJava((String)jsonSchemaBody.getValue())).append("\")");
                    output.append(")");
                } else if (httpRequest.getBody() instanceof XPathBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    XPathBody xPathBody = (XPathBody)httpRequest.getBody();
                    output.append("new XPathBody(\"").append(StringEscapeUtils.escapeJava((String)xPathBody.getValue())).append("\")");
                    output.append(")");
                } else if (httpRequest.getBody() instanceof RegexBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    RegexBody regexBody = (RegexBody)httpRequest.getBody();
                    output.append("new RegexBody(\"").append(StringEscapeUtils.escapeJava((String)regexBody.getValue())).append("\")");
                    output.append(")");
                } else if (httpRequest.getBody() instanceof StringBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    StringBody stringBody = (StringBody)httpRequest.getBody();
                    output.append("new StringBody(\"").append(StringEscapeUtils.escapeJava((String)stringBody.getValue())).append("\")");
                    output.append(")");
                } else if (httpRequest.getBody() instanceof ParameterBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                    output.append("new ParameterBody(");
                    Object bodyParameters = ((ParameterBody)httpRequest.getBody()).getValue();
                    output.append(new ParameterToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 3, (List<Parameter>)bodyParameters));
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                    output.append(")");
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(")");
                } else if (httpRequest.getBody() instanceof BinaryBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    BinaryBody body = (BinaryBody)httpRequest.getBody();
                    output.append(".withBody(Base64Converter.base64StringToBytes(\"").append(Base64Converter.bytesToBase64String(body.getRawBytes())).append("\"))");
                }
            }
        }
        return output.toString();
    }

    private void outputParameters(int numberOfSpacesToIndent, StringBuffer output, String fieldName, List<Parameter> parameters) {
        if (parameters.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".with").append(fieldName).append("s(");
            this.appendObject(numberOfSpacesToIndent, output, new ParameterToJavaSerializer(), parameters);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, List<Cookie> cookies) {
        if (cookies.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, List<Header> headers) {
        if (headers.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> StringBuffer appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        return output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

