/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.util.EntityUtils;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.mappers.ApacheHttpClientToMockServerResponseMapper;
import org.mockserver.model.Cookie;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Parameter;
import org.mockserver.socket.SSLFactory;
import org.mockserver.url.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClient {
    @VisibleForTesting
    static final TrustStrategy trustStrategy = new TrustStrategy(){

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClient.class);
    private ApacheHttpClientToMockServerResponseMapper apacheHttpClientToMockServerResponseMapper = new ApacheHttpClientToMockServerResponseMapper();
    private CloseableHttpClient httpClient;

    public ApacheHttpClient(boolean isSecure) {
        try {
            HttpClientBuilder httpClientBuilder = HttpClients.custom().disableCookieManagement();
            if (isSecure) {
                httpClientBuilder.setSslcontext(SSLContexts.custom().loadTrustMaterial(SSLFactory.getInstance().buildKeyStore(), trustStrategy).build()).setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
            }
            this.httpClient = httpClientBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating http client", e);
        }
    }

    public String sendPUTRequest(String baseUri, String path, String body) {
        try {
            if (baseUri.endsWith("/") && path.startsWith("/")) {
                path = StringUtils.substringAfter((String)path, (String)"/");
            } else if (!baseUri.endsWith("/") && !path.startsWith("/")) {
                baseUri = baseUri + "/";
            }
            HttpPut httpPut = new HttpPut(baseUri + path);
            httpPut.setEntity((HttpEntity)new StringEntity(body, Charsets.UTF_8));
            return new String(EntityUtils.toByteArray((HttpEntity)this.httpClient.execute((HttpUriRequest)httpPut).getEntity()), Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to [" + baseUri + path + "] with body [" + body + "]", e);
        }
    }

    public HttpResponse sendRequest(HttpRequest httpRequest, boolean binaryBody) {
        try {
            Object body;
            URI url = this.buildUrl(httpRequest);
            HttpMethod httpMethod = HttpMethod.parseString(httpRequest.getMethod());
            logger.debug((Object)((Object)httpMethod) + " => " + url);
            HttpUriRequest proxiedRequest = this.createHttpUriRequest(httpMethod, url);
            for (org.mockserver.model.Header header : httpRequest.getHeaders()) {
                String headerName = header.getName();
                if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Transfer-Encoding")) continue;
                if (!header.getValues().isEmpty()) {
                    for (String headerValue : header.getValues()) {
                        proxiedRequest.addHeader(headerName, headerValue);
                    }
                    continue;
                }
                proxiedRequest.addHeader(headerName, "");
            }
            BrowserCompatSpec browserCompatSpec = new BrowserCompatSpec();
            ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
            for (Cookie cookie : httpRequest.getCookies()) {
                if (!cookie.getValues().isEmpty()) {
                    for (String value : cookie.getValues()) {
                        cookies.add(new BasicClientCookie(cookie.getName(), value));
                    }
                    continue;
                }
                cookies.add(new BasicClientCookie(cookie.getName(), ""));
            }
            if (cookies.size() > 0) {
                for (Header header : browserCompatSpec.formatCookies(cookies)) {
                    proxiedRequest.addHeader(header);
                }
            }
            if (binaryBody) {
                body = httpRequest.getBody() != null ? Base64Converter.base64StringToBytes(httpRequest.getBody().toString()) : new byte[]{};
                if (proxiedRequest instanceof HttpEntityEnclosingRequest) {
                    ((HttpEntityEnclosingRequest)proxiedRequest).setEntity((HttpEntity)new ByteArrayEntity((byte[])body));
                }
            } else {
                Object object = body = httpRequest.getBody() != null ? httpRequest.getBody().toString() : "";
                if (proxiedRequest instanceof HttpEntityEnclosingRequest) {
                    ((HttpEntityEnclosingRequest)proxiedRequest).setEntity((HttpEntity)new StringEntity((String)body));
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Proxy sending request:" + System.getProperty("line.separator") + ObjectMapperFactory.createObjectMapper().writeValueAsString((Object)httpRequest));
            }
            return this.apacheHttpClientToMockServerResponseMapper.mapApacheHttpClientResponseToMockServerResponse(this.httpClient.execute(proxiedRequest), binaryBody);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException("MalformedURLException for url [" + httpRequest.getURL() + "]", murle);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("URISyntaxException for url [" + httpRequest.getURL() + "]", use);
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof CircularRedirectException) {
                logger.debug("Circular redirect aborting request", (Throwable)ioe);
                return new HttpResponse();
            }
            throw new RuntimeException("IOException while sending request for url [" + httpRequest.getURL() + "]", ioe);
        }
    }

    private URI buildUrl(HttpRequest httpRequest) throws URISyntaxException, MalformedURLException {
        URL url = new URL(URLEncoder.encodeURL(httpRequest.getURL()));
        if (url.getQuery() != null) {
            httpRequest.withQueryStringParameters(new QueryStringDecoder("?" + url.getQuery()).parameters());
        }
        StringBuilder queryString = new StringBuilder();
        List<Parameter> queryStringParameters = httpRequest.getQueryStringParameters();
        for (int i = 0; i < queryStringParameters.size(); ++i) {
            Parameter parameter = queryStringParameters.get(i);
            if (parameter.getValues().isEmpty()) {
                queryString.append(parameter.getName());
                queryString.append('=');
            } else {
                List<String> values = parameter.getValues();
                for (int j = 0; j < values.size(); ++j) {
                    String value = values.get(j);
                    queryString.append(parameter.getName());
                    queryString.append('=');
                    queryString.append(value);
                    if (j >= values.size() - 1) continue;
                    queryString.append('&');
                }
            }
            if (i >= queryStringParameters.size() - 1) continue;
            queryString.append('&');
        }
        return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), queryString.toString().isEmpty() ? null : queryString.toString(), null);
    }

    protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case TRACE: {
                return new HttpTrace(uri);
            }
            case PATCH: {
                return new HttpPatch(uri);
            }
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + (Object)((Object)httpMethod));
    }

    public static enum HttpMethod {
        GET,
        POST,
        HEAD,
        OPTIONS,
        PUT,
        PATCH,
        DELETE,
        TRACE;


        public static HttpMethod parseString(String string) {
            try {
                return HttpMethod.valueOf(string);
            }
            catch (IllegalArgumentException iae) {
                logger.trace("Not match found for http method [" + string + "]");
                return GET;
            }
        }
    }
}

