/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.model.EqualsHashCodeToString;

public class CircularMultiMap<K, V>
implements Map<K, V> {
    private final int maxValuesPerKeySize;
    private final CircularHashMap<K, List<V>> backingMap;

    public CircularMultiMap(int maxNumberOfKeys, int maxNumberOfValuesPerKey) {
        this.maxValuesPerKeySize = maxNumberOfValuesPerKey;
        this.backingMap = new CircularHashMap(maxNumberOfKeys);
    }

    @Override
    public synchronized int size() {
        return this.backingMap.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        for (Map.Entry entry : this.backingMap.entrySet()) {
            if (!((List)entry.getValue()).contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        List values = (List)this.backingMap.get(key);
        if (values != null && values.size() > 0) {
            return (V)values.get(0);
        }
        return null;
    }

    public synchronized List<V> getAll(Object key) {
        ArrayList values = (ArrayList)this.backingMap.get(key);
        if (values == null) {
            values = new ArrayList();
        }
        return values;
    }

    @Override
    public synchronized V put(K key, V value) {
        if (this.containsKey(key)) {
            ((List)this.backingMap.get(key)).add(value);
        } else {
            List list = Collections.synchronizedList(new CircularLinkedList(this.maxValuesPerKeySize));
            list.add(value);
            this.backingMap.put(key, list);
        }
        return value;
    }

    @Override
    public synchronized V remove(Object key) {
        List values = (List)this.backingMap.get(key);
        if (values != null && values.size() > 0) {
            return (V)values.remove(0);
        }
        return null;
    }

    public synchronized List<V> removeAll(Object key) {
        return (List)this.backingMap.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.backingMap.clear();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public synchronized Collection<V> values() {
        ArrayList values = new ArrayList();
        for (List valuesForKey : this.backingMap.values()) {
            values.addAll(valuesForKey);
        }
        return values;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry entry : this.backingMap.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                entrySet.add(new ImmutableEntry(entry.getKey(), value));
            }
        }
        return entrySet;
    }

    class ImmutableEntry
    extends EqualsHashCodeToString
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        ImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("ImmutableEntry is immutable");
        }
    }
}

