/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.ServerCookieEncoder;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.streams.IOStreamUtils;

public class MockServerToHttpServletResponseMapper {
    public void mapMockServerResponseToHttpServletResponse(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        this.setStatusCode(httpResponse, httpServletResponse);
        this.setHeaders(httpResponse, httpServletResponse);
        this.setCookies(httpResponse, httpServletResponse);
        this.setBody(httpResponse, httpServletResponse);
    }

    private void setStatusCode(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getStatusCode() != null) {
            httpServletResponse.setStatus(httpResponse.getStatusCode().intValue());
        }
    }

    private void setHeaders(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getHeaders() != null) {
            for (Header header : httpResponse.getHeaders()) {
                for (String value : header.getValues()) {
                    httpServletResponse.addHeader(header.getName(), value);
                }
            }
        }
    }

    private void setCookies(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getCookies() != null) {
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookies()) {
                for (String value : cookie.getValues()) {
                    httpServletResponse.addHeader("Set-Cookie", ServerCookieEncoder.encode((Cookie)new DefaultCookie(cookie.getName(), value)));
                }
            }
        }
    }

    private void setBody(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getBodyAsString() != null) {
            if (httpResponse.getBody() instanceof BinaryBody) {
                IOStreamUtils.writeToOutputStream(Base64Converter.base64StringToBytes(httpResponse.getBodyAsString()), (ServletResponse)httpServletResponse);
            } else {
                IOStreamUtils.writeToOutputStream(httpResponse.getBodyAsString().getBytes(), (ServletResponse)httpServletResponse);
            }
        }
    }
}

