/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.IntegerMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.MapMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.XPathStringMatcher;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.EqualsHashCodeToString;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.StringBody;

public class HttpResponseMatcher
extends EqualsHashCodeToString
implements Matcher<HttpResponse> {
    private HttpResponse httpResponse;
    private IntegerMatcher statusCodeMatcher = null;
    private BodyMatcher bodyMatcher = null;
    private MapMatcher headerMatcher = null;
    private MapMatcher cookieMatcher = null;

    public HttpResponseMatcher(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        if (httpResponse != null) {
            this.withStatusCode(httpResponse.getStatusCode());
            this.withBody(httpResponse.getBody());
            this.withHeaders(httpResponse.getHeaders());
            this.withCookies(httpResponse.getCookies());
        }
    }

    private HttpResponseMatcher withStatusCode(Integer statusCode) {
        this.statusCodeMatcher = new IntegerMatcher(statusCode);
        return this;
    }

    private HttpResponseMatcher withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    this.bodyMatcher = new ExactStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case REGEX: {
                    this.bodyMatcher = new RegexStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case XPATH: {
                    this.bodyMatcher = new XPathStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case JSON: {
                    this.bodyMatcher = new JsonStringMatcher(((StringBody)body).getValue());
                    break;
                }
                case BINARY: {
                    this.bodyMatcher = new BinaryMatcher(((BinaryBody)body).getValue());
                }
            }
        }
        return this;
    }

    private HttpResponseMatcher withHeaders(Header ... headers) {
        this.headerMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpResponseMatcher withHeaders(List<Header> headers) {
        this.headerMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpResponseMatcher withCookies(Cookie ... cookies) {
        this.cookieMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(cookies));
        return this;
    }

    private HttpResponseMatcher withCookies(List<Cookie> cookies) {
        this.cookieMatcher = new MapMatcher(KeyToMultiValue.toMultiMap(cookies));
        return this;
    }

    @Override
    public boolean matches(HttpResponse httpResponse) {
        if (httpResponse != null) {
            boolean result;
            boolean statusCodeMatches = this.matches(this.statusCodeMatcher, httpResponse.getStatusCode());
            boolean bodyMatches = this.bodyMatcher instanceof BinaryMatcher ? this.matches(this.bodyMatcher, httpResponse.getRawBodyBytes()) : this.matches(this.bodyMatcher, httpResponse.getBody() != null ? httpResponse.getBody().toString() : "");
            boolean headersMatch = this.matches(this.headerMatcher, httpResponse.getHeaders() != null ? new ArrayList<Header>(httpResponse.getHeaders()) : null);
            boolean cookiesMatch = this.matches(this.cookieMatcher, httpResponse.getCookies() != null ? new ArrayList<Cookie>(httpResponse.getCookies()) : null);
            boolean bl = result = statusCodeMatches && bodyMatches && headersMatch && cookiesMatch;
            if (!result && this.logger.isDebugEnabled()) {
                this.logger.debug("\n\nMatcher:" + System.getProperty("line.separator") + System.getProperty("line.separator") + "[" + this + "]" + System.getProperty("line.separator") + System.getProperty("line.separator") + "did not match request:" + System.getProperty("line.separator") + System.getProperty("line.separator") + "[" + httpResponse + "]" + System.getProperty("line.separator") + System.getProperty("line.separator") + "because:" + System.getProperty("line.separator") + System.getProperty("line.separator") + "statusCodeMatches = " + statusCodeMatches + "" + System.getProperty("line.separator") + "bodyMatches = " + bodyMatches + "" + System.getProperty("line.separator") + "headersMatch = " + headersMatch + "" + System.getProperty("line.separator") + "cookiesMatch = " + cookiesMatch);
            }
            return result;
        }
        return false;
    }

    private <T> boolean matches(Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(t)) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.httpResponse);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

