/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Strings;
import java.util.regex.PatternSyntaxException;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexStringMatcher
extends BodyMatcher<String>
implements Matcher<String> {
    private static Logger logger = LoggerFactory.getLogger(RegexStringMatcher.class);
    private final String matcher;

    public RegexStringMatcher(String matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (Strings.isNullOrEmpty((String)matcher)) {
            result = true;
        } else if (matched != null) {
            try {
                if (matched.matches(matcher)) {
                    result = true;
                }
            }
            catch (PatternSyntaxException pse) {
                logger.trace("Error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage());
            }
            try {
                if (matcher.matches(matched)) {
                    result = true;
                }
            }
            catch (PatternSyntaxException pse) {
                logger.trace("Error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage());
            }
            if (ignoreCase) {
                try {
                    if (matched.toLowerCase().matches(matcher.toLowerCase())) {
                        result = true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    logger.trace("Error while matching regex [" + matcher.toLowerCase() + "] for string [" + matched.toLowerCase() + "] " + pse.getMessage());
                }
                try {
                    if (matcher.toLowerCase().matches(matched.toLowerCase())) {
                        result = true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    logger.trace("Error while matching regex [" + matched.toLowerCase() + "] for string [" + matcher.toLowerCase() + "] " + pse.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        if (RegexStringMatcher.matches(this.matcher, matched, false)) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return result;
    }
}

