/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.proxy.filters.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallbackActionHandler {
    private final Filters filters;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpCallbackActionHandler(Filters filters) {
        this.filters = filters;
    }

    public HttpResponse handle(HttpCallback httpCallback, HttpRequest httpRequest) {
        return this.sendRequest(httpCallback, this.filters.applyFilters(httpRequest));
    }

    private ExpectationCallback instantiateCallback(HttpCallback httpCallback) {
        try {
            Class<?> expectationCallbackClass = Class.forName(httpCallback.getCallbackClass());
            if (ExpectationCallback.class.isAssignableFrom(expectationCallbackClass)) {
                Constructor<?> constructor = expectationCallbackClass.getConstructor(new Class[0]);
                return (ExpectationCallback)constructor.newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error("ClassNotFoundException - while trying to instantiate ExceptionCallback class \"" + httpCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("NoSuchMethodException - while trying to create default constructor on ExceptionCallback class \"" + httpCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("InvocationTargetException - while trying to execute default constructor on ExceptionCallback class \"" + httpCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.logger.error("InvocationTargetException - while trying to execute default constructor on ExceptionCallback class \"" + httpCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("InvocationTargetException - while trying to execute default constructor on ExceptionCallback class \"" + httpCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        return null;
    }

    private HttpResponse sendRequest(HttpCallback httpCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationCallback expectationCallback = this.instantiateCallback(httpCallback);
            if (expectationCallback != null) {
                return this.filters.applyFilters(httpRequest, expectationCallback.handle(httpRequest));
            }
            return HttpResponse.response().withStatusCode(404);
        }
        return HttpResponse.response().withStatusCode(404);
    }
}

